/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.route;

import apache.rocketmq.v2.MessageQueue;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.java.message.MessageType;
import org.apache.rocketmq.client.java.message.protocol.Resource;
import org.apache.rocketmq.client.java.route.Broker;
import org.apache.rocketmq.client.java.route.Permission;

public class MessageQueueImpl {
    private final Resource topicResource;
    private final Broker broker;
    private final int queueId;
    private final Permission permission;
    private final List<MessageType> acceptMessageTypes;

    public MessageQueueImpl(MessageQueue messageQueue) {
        this.topicResource = new Resource(messageQueue.getTopic());
        this.queueId = messageQueue.getId();
        apache.rocketmq.v2.Permission perm = messageQueue.getPermission();
        this.permission = Permission.fromProtobuf(perm);
        this.acceptMessageTypes = new ArrayList<MessageType>();
        List types = messageQueue.getAcceptMessageTypesList();
        for (apache.rocketmq.v2.MessageType type : types) {
            this.acceptMessageTypes.add(MessageType.fromProtobuf(type));
        }
        this.broker = new Broker(messageQueue.getBroker());
    }

    public Resource getTopicResource() {
        return this.topicResource;
    }

    public String getTopic() {
        return this.topicResource.getName();
    }

    public Broker getBroker() {
        return this.broker;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public List<MessageType> getAcceptMessageTypes() {
        return this.acceptMessageTypes;
    }

    public MessageQueue toProtobuf() {
        List messageTypes = this.acceptMessageTypes.stream().map(MessageType::toProtobuf).collect(Collectors.toList());
        return MessageQueue.newBuilder().setTopic(this.topicResource.toProtobuf()).setId(this.queueId).setPermission(Permission.toProtobuf(this.permission)).setBroker(this.broker.toProtobuf()).addAllAcceptMessageTypes(messageTypes).build();
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageQueueImpl messageQueueImpl = (MessageQueueImpl)o;
        return this.queueId == messageQueueImpl.queueId && Objects.equal((Object)this.topicResource, (Object)messageQueueImpl.topicResource) && Objects.equal((Object)this.broker, (Object)messageQueueImpl.broker) && this.permission == messageQueueImpl.permission;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topicResource, this.broker, this.queueId, this.permission});
    }

    public String toString() {
        return this.broker.getName() + "." + this.topicResource + "." + this.queueId;
    }
}

