/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace.hook;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import org.apache.rocketmq.client.hook.SendMessageContext;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;

public class SendMessageOpenTracingHookImpl
implements SendMessageHook {
    private Tracer tracer;

    public SendMessageOpenTracingHookImpl(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public String hookName() {
        return "SendMessageOpenTracingHook";
    }

    @Override
    public void sendMessageBefore(SendMessageContext context) {
        if (context == null) {
            return;
        }
        Message msg = context.getMessage();
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan("To_" + msg.getTopic()).withTag((Tag)Tags.SPAN_KIND, (Object)"producer");
        SpanContext spanContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(msg.getProperties()));
        if (spanContext != null) {
            spanBuilder.asChildOf(spanContext);
        }
        Span span = spanBuilder.start();
        this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(msg.getProperties()));
        span.setTag((Tag)Tags.PEER_SERVICE, (Object)"rocketmq");
        span.setTag((Tag)Tags.MESSAGE_BUS_DESTINATION, (Object)msg.getTopic());
        span.setTag("rocketmq.tags", msg.getTags());
        span.setTag("rocketmq.keys", msg.getKeys());
        span.setTag("rocketmq.store_host", context.getBrokerAddr());
        span.setTag("rocketmq.mgs_type", context.getMsgType().name());
        span.setTag("rocketmq.body_length", (Number)(null == msg.getBody() ? 0 : msg.getBody().length));
        context.setMqTraceContext(span);
    }

    @Override
    public void sendMessageAfter(SendMessageContext context) {
        if (context == null || context.getMqTraceContext() == null) {
            return;
        }
        if (context.getSendResult() == null) {
            return;
        }
        if (context.getSendResult().getRegionId() == null) {
            return;
        }
        Span span = (Span)context.getMqTraceContext();
        span.setTag("rocketmq.success", context.getSendResult().getSendStatus().equals((Object)SendStatus.SEND_OK));
        span.setTag("rocketmq.mgs_id", context.getSendResult().getMsgId());
        span.setTag("rocketmq.region_id", context.getSendResult().getRegionId());
        span.finish();
    }
}

