/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.UUID;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;

public class OzoneSnapshot {
    private final String volumeName;
    private final String bucketName;
    private final String name;
    private final long creationTime;
    private final SnapshotInfo.SnapshotStatus snapshotStatus;
    private final UUID snapshotId;
    private final String snapshotPath;
    private final String checkpointDir;
    private final long referencedSize;
    private final long referencedReplicatedSize;
    private final long exclusiveSize;
    private final long exclusiveReplicatedSize;

    public OzoneSnapshot(String volumeName, String bucketName, String name, long creationTime, SnapshotInfo.SnapshotStatus snapshotStatus, UUID snapshotId, String snapshotPath, String checkpointDir, long referencedSize, long referencedReplicatedSize, long exclusiveSize, long exclusiveReplicatedSize) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.name = name;
        this.creationTime = creationTime;
        this.snapshotStatus = snapshotStatus;
        this.snapshotId = snapshotId;
        this.snapshotPath = snapshotPath;
        this.checkpointDir = checkpointDir;
        this.referencedSize = referencedSize;
        this.referencedReplicatedSize = referencedReplicatedSize;
        this.exclusiveSize = exclusiveSize;
        this.exclusiveReplicatedSize = exclusiveReplicatedSize;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getName() {
        return this.name;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getSnapshotStatus() {
        return this.snapshotStatus.name();
    }

    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public String getCheckpointDir() {
        return this.checkpointDir;
    }

    public long getReferencedSize() {
        return this.referencedSize;
    }

    public long getReferencedReplicatedSize() {
        return this.referencedReplicatedSize;
    }

    public long getExclusiveSize() {
        return this.exclusiveSize;
    }

    public long getExclusiveReplicatedSize() {
        return this.exclusiveReplicatedSize;
    }

    public static OzoneSnapshot fromSnapshotInfo(SnapshotInfo snapshotInfo) {
        return new OzoneSnapshot(snapshotInfo.getVolumeName(), snapshotInfo.getBucketName(), snapshotInfo.getName(), snapshotInfo.getCreationTime(), snapshotInfo.getSnapshotStatus(), snapshotInfo.getSnapshotId(), snapshotInfo.getSnapshotPath(), snapshotInfo.getCheckpointDir(), snapshotInfo.getReferencedSize(), snapshotInfo.getReferencedReplicatedSize(), snapshotInfo.getExclusiveSize(), snapshotInfo.getExclusiveReplicatedSize());
    }
}

