/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ShortArrayBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class ShortArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ShortArrayBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new ShortArrayBlock(0, 1, new boolean[]{true}, new short[1]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private short[] values = new short[0];
    private long retainedSizeInBytes;

    public ShortArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    public ShortArrayBlockBuilder writeShort(short value) {
        this.ensureCapacity(this.positionCount + 1);
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(3);
        }
        return this;
    }

    @Override
    public void append(ValueBlock block, int position) {
        this.ensureCapacity(this.positionCount + 1);
        ShortArrayBlock shortArrayBlock = (ShortArrayBlock)block;
        if (shortArrayBlock.isNull(position)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            this.values[this.positionCount] = shortArrayBlock.getShort(position);
            this.hasNonNullValue = true;
        }
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(3);
        }
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.append(block, position);
            return;
        }
        this.ensureCapacity(this.positionCount + count);
        ShortArrayBlock shortArrayBlock = (ShortArrayBlock)block;
        if (shortArrayBlock.isNull(position)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + count, true);
            this.hasNullValue = true;
        } else {
            short value = shortArrayBlock.getShort(position);
            Arrays.fill(this.values, this.positionCount, this.positionCount + count, value);
            this.hasNonNullValue = true;
        }
        this.positionCount += count;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(count * 3);
        }
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, offset);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        ShortArrayBlock shortArrayBlock = (ShortArrayBlock)block;
        int rawOffset = shortArrayBlock.getRawValuesOffset();
        short[] rawValues = shortArrayBlock.getRawValues();
        System.arraycopy(rawValues, rawOffset + offset, this.values, this.positionCount, length);
        boolean[] rawValueIsNull = shortArrayBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                if (rawValueIsNull[rawOffset + offset + i]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.hasNonNullValue = true;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 3);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, positions[offset]);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        ShortArrayBlock shortArrayBlock = (ShortArrayBlock)block;
        int rawOffset = shortArrayBlock.getRawValuesOffset();
        short[] rawValues = shortArrayBlock.getRawValues();
        boolean[] rawValueIsNull = shortArrayBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                if (rawValueIsNull[rawPosition]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.values[this.positionCount + i] = rawValues[rawPosition];
                this.hasNonNullValue = true;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                this.values[this.positionCount + i] = rawValues[rawPosition];
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 3);
        }
    }

    @Override
    public ShortArrayBlockBuilder appendNull() {
        this.ensureCapacity(this.positionCount + 1);
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(3);
        }
        return this;
    }

    @Override
    public void resetTo(int position) {
        Objects.checkIndex(position, this.positionCount + 1);
        this.positionCount = position;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public ShortArrayBlock buildValueBlock() {
        return new ShortArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new ShortArrayBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.values.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(capacity);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateRetainedSize();
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((short[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 3L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ShortArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

