/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaUtil;
import java.util.Objects;
import java.util.Optional;

public class SchemaTablePrefix {
    private final Optional<String> schemaName;
    private final Optional<String> tableName;

    public SchemaTablePrefix() {
        this.schemaName = Optional.empty();
        this.tableName = Optional.empty();
    }

    public SchemaTablePrefix(String schemaName) {
        this.schemaName = Optional.of(SchemaUtil.checkNotEmpty(schemaName, "schemaName"));
        this.tableName = Optional.empty();
    }

    public SchemaTablePrefix(String schemaName, String tableName) {
        this.schemaName = Optional.of(SchemaUtil.checkNotEmpty(schemaName, "schemaName"));
        this.tableName = Optional.of(SchemaUtil.checkNotEmpty(tableName, "tableName"));
    }

    public Optional<String> getSchema() {
        return this.schemaName;
    }

    public Optional<String> getTable() {
        return this.tableName;
    }

    public boolean matches(SchemaTableName schemaTableName) {
        if (this.isEmpty()) {
            return true;
        }
        if (!this.schemaName.get().equals(schemaTableName.getSchemaName())) {
            return false;
        }
        return !this.tableName.isPresent() || this.tableName.get().equals(schemaTableName.getTableName());
    }

    public boolean isEmpty() {
        return !this.schemaName.isPresent();
    }

    public SchemaTableName toSchemaTableName() {
        return this.toOptionalSchemaTableName().orElseThrow(() -> new IllegalStateException("both schemaName and tableName must be set"));
    }

    public Optional<SchemaTableName> toOptionalSchemaTableName() {
        if (this.schemaName.isPresent() && this.tableName.isPresent()) {
            return Optional.of(new SchemaTableName(this.schemaName.get(), this.tableName.get()));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTablePrefix other = (SchemaTablePrefix)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return this.schemaName.orElse("*") + '.' + this.tableName.orElse("*");
    }
}

