/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.client.ErrorLocation;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableCollection;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@.Immutable
public class FailureInfo {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final String type;
    private final String message;
    private final FailureInfo cause;
    private final List<FailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorLocation errorLocation;

    @.JsonCreator
    public FailureInfo(@.JsonProperty(value="type") String type, @.JsonProperty(value="message") String message, @.JsonProperty(value="cause") FailureInfo cause, @.JsonProperty(value="suppressed") List<FailureInfo> suppressed, @.JsonProperty(value="stack") List<String> stack, @.JsonProperty(value="errorLocation") @.Nullable ErrorLocation errorLocation) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(suppressed, "suppressed is null");
        Objects.requireNonNull(stack, "stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorLocation = errorLocation;
    }

    @.JsonProperty
    public String getType() {
        return this.type;
    }

    @.Nullable
    @.JsonProperty
    public String getMessage() {
        return this.message;
    }

    @.Nullable
    @.JsonProperty
    public FailureInfo getCause() {
        return this.cause;
    }

    @.JsonProperty
    public List<FailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @.JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @.Nullable
    @.JsonProperty
    public ErrorLocation getErrorLocation() {
        return this.errorLocation;
    }

    public RuntimeException toException() {
        return FailureInfo.toException(this);
    }

    private static FailureException toException(FailureInfo failureInfo) {
        if (failureInfo == null) {
            return null;
        }
        FailureException failure = new FailureException(failureInfo.getType(), failureInfo.getMessage(), FailureInfo.toException(failureInfo.getCause()));
        for (FailureInfo failureInfo2 : failureInfo.getSuppressed()) {
            failure.addSuppressed(FailureInfo.toException(failureInfo2));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : failureInfo.getStack()) {
            stackTraceBuilder.add(FailureInfo.toStackTraceElement(stack));
        }
        ImmutableCollection immutableCollection = stackTraceBuilder.build();
        failure.setStackTrace(immutableCollection.toArray(new StackTraceElement[immutableCollection.size()]));
        return failure;
    }

    public static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }

    private static class FailureException
    extends RuntimeException {
        private final String type;

        FailureException(String type, String message, FailureException cause) {
            super(message, cause);
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String toString() {
            String message = this.getMessage();
            if (message != null) {
                return this.type + ": " + message;
            }
            return this.type;
        }
    }
}

