/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataChangeFilter is the corresponding interface of DataChangeFilter
type DataChangeFilter interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetTrigger returns Trigger (property field)
	GetTrigger() DataChangeTrigger
	// GetDeadbandType returns DeadbandType (property field)
	GetDeadbandType() uint32
	// GetDeadbandValue returns DeadbandValue (property field)
	GetDeadbandValue() float64
	// IsDataChangeFilter is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataChangeFilter()
	// CreateBuilder creates a DataChangeFilterBuilder
	CreateDataChangeFilterBuilder() DataChangeFilterBuilder
}

// _DataChangeFilter is the data-structure of this message
type _DataChangeFilter struct {
	ExtensionObjectDefinitionContract
	Trigger       DataChangeTrigger
	DeadbandType  uint32
	DeadbandValue float64
}

var _ DataChangeFilter = (*_DataChangeFilter)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DataChangeFilter)(nil)

// NewDataChangeFilter factory function for _DataChangeFilter
func NewDataChangeFilter(trigger DataChangeTrigger, deadbandType uint32, deadbandValue float64) *_DataChangeFilter {
	_result := &_DataChangeFilter{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Trigger:                           trigger,
		DeadbandType:                      deadbandType,
		DeadbandValue:                     deadbandValue,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataChangeFilterBuilder is a builder for DataChangeFilter
type DataChangeFilterBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(trigger DataChangeTrigger, deadbandType uint32, deadbandValue float64) DataChangeFilterBuilder
	// WithTrigger adds Trigger (property field)
	WithTrigger(DataChangeTrigger) DataChangeFilterBuilder
	// WithDeadbandType adds DeadbandType (property field)
	WithDeadbandType(uint32) DataChangeFilterBuilder
	// WithDeadbandValue adds DeadbandValue (property field)
	WithDeadbandValue(float64) DataChangeFilterBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DataChangeFilter or returns an error if something is wrong
	Build() (DataChangeFilter, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataChangeFilter
}

// NewDataChangeFilterBuilder() creates a DataChangeFilterBuilder
func NewDataChangeFilterBuilder() DataChangeFilterBuilder {
	return &_DataChangeFilterBuilder{_DataChangeFilter: new(_DataChangeFilter)}
}

type _DataChangeFilterBuilder struct {
	*_DataChangeFilter

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (DataChangeFilterBuilder) = (*_DataChangeFilterBuilder)(nil)

func (b *_DataChangeFilterBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DataChangeFilter
}

func (b *_DataChangeFilterBuilder) WithMandatoryFields(trigger DataChangeTrigger, deadbandType uint32, deadbandValue float64) DataChangeFilterBuilder {
	return b.WithTrigger(trigger).WithDeadbandType(deadbandType).WithDeadbandValue(deadbandValue)
}

func (b *_DataChangeFilterBuilder) WithTrigger(trigger DataChangeTrigger) DataChangeFilterBuilder {
	b.Trigger = trigger
	return b
}

func (b *_DataChangeFilterBuilder) WithDeadbandType(deadbandType uint32) DataChangeFilterBuilder {
	b.DeadbandType = deadbandType
	return b
}

func (b *_DataChangeFilterBuilder) WithDeadbandValue(deadbandValue float64) DataChangeFilterBuilder {
	b.DeadbandValue = deadbandValue
	return b
}

func (b *_DataChangeFilterBuilder) Build() (DataChangeFilter, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DataChangeFilter.deepCopy(), nil
}

func (b *_DataChangeFilterBuilder) MustBuild() DataChangeFilter {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataChangeFilterBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DataChangeFilterBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DataChangeFilterBuilder) DeepCopy() any {
	_copy := b.CreateDataChangeFilterBuilder().(*_DataChangeFilterBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDataChangeFilterBuilder creates a DataChangeFilterBuilder
func (b *_DataChangeFilter) CreateDataChangeFilterBuilder() DataChangeFilterBuilder {
	if b == nil {
		return NewDataChangeFilterBuilder()
	}
	return &_DataChangeFilterBuilder{_DataChangeFilter: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataChangeFilter) GetExtensionId() int32 {
	return int32(724)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataChangeFilter) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataChangeFilter) GetTrigger() DataChangeTrigger {
	return m.Trigger
}

func (m *_DataChangeFilter) GetDeadbandType() uint32 {
	return m.DeadbandType
}

func (m *_DataChangeFilter) GetDeadbandValue() float64 {
	return m.DeadbandValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDataChangeFilter(structType any) DataChangeFilter {
	if casted, ok := structType.(DataChangeFilter); ok {
		return casted
	}
	if casted, ok := structType.(*DataChangeFilter); ok {
		return *casted
	}
	return nil
}

func (m *_DataChangeFilter) GetTypeName() string {
	return "DataChangeFilter"
}

func (m *_DataChangeFilter) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (trigger)
	lengthInBits += 32

	// Simple field (deadbandType)
	lengthInBits += 32

	// Simple field (deadbandValue)
	lengthInBits += 64

	return lengthInBits
}

func (m *_DataChangeFilter) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DataChangeFilter) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__dataChangeFilter DataChangeFilter, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataChangeFilter"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataChangeFilter")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	trigger, err := ReadEnumField[DataChangeTrigger](ctx, "trigger", "DataChangeTrigger", ReadEnum(DataChangeTriggerByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'trigger' field"))
	}
	m.Trigger = trigger

	deadbandType, err := ReadSimpleField(ctx, "deadbandType", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deadbandType' field"))
	}
	m.DeadbandType = deadbandType

	deadbandValue, err := ReadSimpleField(ctx, "deadbandValue", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deadbandValue' field"))
	}
	m.DeadbandValue = deadbandValue

	if closeErr := readBuffer.CloseContext("DataChangeFilter"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataChangeFilter")
	}

	return m, nil
}

func (m *_DataChangeFilter) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataChangeFilter) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataChangeFilter"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataChangeFilter")
		}

		if err := WriteSimpleEnumField[DataChangeTrigger](ctx, "trigger", "DataChangeTrigger", m.GetTrigger(), WriteEnum[DataChangeTrigger, uint32](DataChangeTrigger.GetValue, DataChangeTrigger.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'trigger' field")
		}

		if err := WriteSimpleField[uint32](ctx, "deadbandType", m.GetDeadbandType(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'deadbandType' field")
		}

		if err := WriteSimpleField[float64](ctx, "deadbandValue", m.GetDeadbandValue(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'deadbandValue' field")
		}

		if popErr := writeBuffer.PopContext("DataChangeFilter"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataChangeFilter")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataChangeFilter) IsDataChangeFilter() {}

func (m *_DataChangeFilter) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataChangeFilter) deepCopy() *_DataChangeFilter {
	if m == nil {
		return nil
	}
	_DataChangeFilterCopy := &_DataChangeFilter{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.Trigger,
		m.DeadbandType,
		m.DeadbandValue,
	}
	_DataChangeFilterCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DataChangeFilterCopy
}

func (m *_DataChangeFilter) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
