/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.operations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.operations.BaseOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.QueryOperation;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOperationSupplier
extends BaseOperationSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryOperationSupplier.class);

    public QueryOperationSupplier(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario) {
        super(phoenixUtil, model, scenario);
    }

    @Override
    public Function<TenantOperationInfo, OperationStats> get() {
        return new Function<TenantOperationInfo, OperationStats>(){

            @Override
            public OperationStats apply(TenantOperationInfo input) {
                Preconditions.checkNotNull(input);
                QueryOperation operation = (QueryOperation)input.getOperation();
                Query query = operation.getQuery();
                String tenantGroup = input.getTenantGroupId();
                String opGroup = input.getOperationGroupId();
                String scenarioName = input.getScenarioName();
                String tableName = input.getTableName();
                boolean isTenantGroupGlobal = tenantGroup.compareTo("GLOBAL") == 0;
                String tenantId = isTenantGroupGlobal || query.isUseGlobalConnection() ? null : input.getTenantId();
                String opName = String.format("%s:%s:%s:%s:%s", scenarioName, tableName, opGroup, tenantGroup, input.getTenantId());
                LOGGER.debug("\nExecuting query " + query.getStatement());
                long startTime = 0L;
                int status = 0;
                Long resultRowCount = 0L;
                Long queryElapsedTime = 0L;
                try (Connection connection = QueryOperationSupplier.this.phoenixUtil.getConnection(tenantId);){
                    startTime = EnvironmentEdgeManager.currentTimeMillis();
                    try (PreparedStatement statement = connection.prepareStatement(query.getStatement());
                         ResultSet rs = statement.executeQuery();){
                        boolean isSelectCountStatement = query.getStatement().toUpperCase().trim().contains("COUNT(");
                        Pair<Long, Long> r = QueryOperationSupplier.this.phoenixUtil.getResults(query, rs, opName, isSelectCountStatement, startTime);
                        resultRowCount = (Long)r.getFirst();
                        queryElapsedTime = (Long)r.getSecond();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Operation " + opName + " failed with exception ", (Throwable)e);
                    status = -1;
                }
                return new OperationStats(input, startTime, status, resultRowCount, queryElapsedTime);
            }
        };
    }
}

