/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.dropdown;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.event.ISelectionChangedListener;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.ajax.OnChangeAjaxBehavior;

public class DropDownChoiceBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "selectmenu";
    private final ISelectionChangedListener listener;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;

    public DropDownChoiceBehavior(String selector, ISelectionChangedListener listener) {
        this(selector, METHOD, listener);
    }

    public DropDownChoiceBehavior(String selector, String method, ISelectionChangedListener listener) {
        super(selector, method);
        this.listener = (ISelectionChangedListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isSelectionChangedEventEnabled()) {
            this.onChangeAjaxBehavior = new OnChangeAjaxBehavior(this, new FormComponent[0]);
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.listener.onSelectionChanged(target);
        }
    }
}

