/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PrivateApi
public class ResourceConfig
implements IdentifiedDataSerializable {
    private URL url;
    private String id;
    private ResourceType resourceType;

    ResourceConfig() {
    }

    public ResourceConfig(@Nonnull URL url, @Nullable String id, @Nonnull ResourceType resourceType) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(resourceType, "resourceType");
        this.url = url;
        this.id = ConfigUtils.resolveResourceId(id, url);
        this.resourceType = resourceType;
    }

    private ResourceConfig(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        this.id = ReflectionUtils.toClassResourceId(clazz.getName());
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            throw new IllegalArgumentException(clazz.getName() + ".getClassLoader() returned null, cannot access the class resource. You may have added a JDK class that is loaded by the bootstrap classloader. There is no need to add JDK classes to the job configuration.");
        }
        this.url = cl.getResource(this.id);
        if (this.url == null) {
            throw new IllegalArgumentException("The classloader of " + clazz.getName() + " couldn't resolve the resource URL of " + this.id);
        }
        this.resourceType = ResourceType.CLASS;
    }

    public static Stream<ResourceConfig> fromClass(Class<?> ... classes) {
        return ReflectionUtils.nestedClassesOf(classes).stream().map(ResourceConfig::new);
    }

    @Nonnull
    public URL getUrl() {
        return this.url;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return "ResourceConfig{url=" + this.url + ", id='" + this.id + "', resourceType=" + this.resourceType + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfig that = (ResourceConfig)o;
        return this.url.toString().equals(that.url.toString()) && this.id.equals(that.id) && this.resourceType == that.resourceType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.id, this.resourceType});
    }

    @Override
    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.id);
        out.writeShort(this.resourceType.getId());
        out.writeObject(this.url);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readString();
        this.resourceType = ResourceType.getById(in.readShort());
        this.url = (URL)in.readObject();
    }
}

