/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheSyncListenerCompleter;
import com.hazelcast.cache.impl.CacheProxySupport;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class CacheProxySyncListenerCompleter
extends AbstractCacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    private final CacheProxySupport cacheProxy;

    CacheProxySyncListenerCompleter(CacheProxySupport cacheProxy) {
        this.cacheProxy = cacheProxy;
    }

    @Override
    protected void awaitLatch(CountDownLatch countDownLatch, InternalCompletableFuture future) {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                if (!this.cacheProxy.getNodeEngine().isRunning()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.cacheProxy.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.cacheProxy.getPrefixedName() + ") is closed!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ExceptionUtil.sneakyThrow(e);
        }
    }
}

