/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ReturnValueDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.ExecutableD;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.util.ValidatorUtils;
import org.apache.bval.util.reflection.TypeUtils;

public class ReturnValueD<P extends ExecutableD<?, ?, P>, E extends Executable>
extends CascadableContainerD<P, E>
implements ReturnValueDescriptor {
    private final Set<ConstraintD<?>> constraints;

    ReturnValueD(MetadataReader.ForContainer<E> reader, P parent) {
        super(reader, parent);
        this.constraints = new HashSet(reader.getConstraints());
        Class<?> validatedType = reader.meta.getHost() instanceof Constructor ? reader.meta.getDeclaringClass() : ((Method)reader.meta.getHost()).getReturnType();
        for (ConstraintDescriptor constraintDescriptor : this.constraints) {
            if (this.hasValidatorForType(validatedType, constraintDescriptor) || constraintDescriptor.getConstraintValidatorClasses().isEmpty() && constraintDescriptor.getComposingConstraints().isEmpty()) continue;
            String msg = "No validator found for (composition) constraint @" + constraintDescriptor.getAnnotation().annotationType().getSimpleName() + " declared on \"" + ((Executable)reader.meta.getHost()).toString() + "\" for validated type \"" + validatedType.getName() + "\"";
            throw new UnexpectedTypeException(msg);
        }
    }

    private boolean hasValidatorForType(Class<?> validatedType, ConstraintDescriptor<?> c) {
        for (Class<ConstraintValidator<?, ?>> clazz : c.getConstraintValidatorClasses()) {
            if (!TypeUtils.isAssignable(validatedType, ValidatorUtils.getValidatedType(clazz))) continue;
            return true;
        }
        for (ConstraintDescriptor constraintDescriptor : c.getComposingConstraints()) {
            if (!this.hasValidatorForType(validatedType, constraintDescriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    @Override
    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraints;
    }
}

