/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;
import org.apache.olingo.odata2.core.ep.util.JsonUtils;

public class JsonDeletedEntryEntityProducer {
    private EntityProviderWriteProperties properties;

    public JsonDeletedEntryEntityProducer(EntityProviderWriteProperties properties) {
        this.properties = properties;
    }

    public void append(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> deletedEntries, boolean noPreviousEntries) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            if (!deletedEntries.isEmpty()) {
                if (!noPreviousEntries) {
                    jsonStreamWriter.separator();
                }
                int counter = 0;
                for (Map<String, Object> deletedEntry : deletedEntries) {
                    jsonStreamWriter.beginObject();
                    String odataContextValue = JsonUtils.createODataContextValueForTombstone(entityInfo.getEntitySetName());
                    String selfLink = AtomEntryEntityProducer.createSelfLink(entityInfo, deletedEntry, null);
                    String idValue = this.properties.getServiceRoot().toASCIIString() + selfLink;
                    jsonStreamWriter.namedStringValue("@odata.context", odataContextValue);
                    jsonStreamWriter.separator();
                    jsonStreamWriter.namedStringValue("id", idValue);
                    jsonStreamWriter.endObject();
                    if (counter < deletedEntries.size() - 1) {
                        jsonStreamWriter.separator();
                    }
                    ++counter;
                }
            }
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }
}

