/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.edm;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationHelper;
import org.apache.olingo.odata2.annotation.processor.core.util.ClassHelper;
import org.apache.olingo.odata2.api.annotation.edm.EdmComplexType;
import org.apache.olingo.odata2.api.annotation.edm.EdmConcurrencyControl;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntityType;
import org.apache.olingo.odata2.api.annotation.edm.EdmKey;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceContent;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceMimeType;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceSource;
import org.apache.olingo.odata2.api.annotation.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AnnotationAttribute;
import org.apache.olingo.odata2.api.edm.provider.AnnotationElement;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.edm.provider.Using;
import org.apache.olingo.odata2.api.exception.ODataException;

public class AnnotationEdmProvider
extends EdmProvider {
    private static final AnnotationHelper ANNOTATION_HELPER = new AnnotationHelper();
    private final List<Class<?>> annotatedClasses;
    private final Map<String, EntityContainer> name2Container = new HashMap<String, EntityContainer>();
    private final Map<String, ContainerBuilder> containerName2ContainerBuilder = new HashMap<String, ContainerBuilder>();
    private final Map<String, Schema> namespace2Schema = new HashMap<String, Schema>();
    private EntityContainer defaultContainer;
    private Map<String, SchemaBuilder> namespace2SchemaBuilder = new HashMap<String, SchemaBuilder>();

    public AnnotationEdmProvider(Collection<Class<?>> annotatedClasses) throws ODataException {
        this.annotatedClasses = new ArrayList(annotatedClasses.size());
        for (Class<?> aClass : annotatedClasses) {
            if (!ANNOTATION_HELPER.isEdmAnnotated(aClass)) continue;
            this.annotatedClasses.add(aClass);
        }
        this.init();
    }

    public AnnotationEdmProvider(String packageToScan) throws ODataException {
        this.annotatedClasses = ClassHelper.loadClasses(packageToScan, new ClassHelper.ClassValidator(){

            @Override
            public boolean isClassValid(Class<?> c) {
                return ANNOTATION_HELPER.isEdmAnnotated(c);
            }
        });
        this.init();
    }

    private void init() throws ODataException {
        for (Class<?> aClass : this.annotatedClasses) {
            this.updateSchema(aClass);
            this.handleEntityContainer(aClass);
        }
        this.finish();
    }

    public Association getAssociation(FullQualifiedName edmFQName) throws ODataException {
        Schema schema = this.namespace2Schema.get(edmFQName.getNamespace());
        if (schema != null) {
            List associations = schema.getAssociations();
            for (Association association : associations) {
                if (!association.getName().equals(edmFQName.getName())) continue;
                return association;
            }
        }
        return null;
    }

    public AssociationSet getAssociationSet(String entityContainer, FullQualifiedName association, String sourceEntitySetName, String sourceEntitySetRole) throws ODataException {
        EntityContainer container = this.name2Container.get(entityContainer);
        if (container != null) {
            List associations = container.getAssociationSets();
            for (AssociationSet associationSet : associations) {
                if (!associationSet.getAssociation().equals((Object)association)) continue;
                AssociationSetEnd endOne = associationSet.getEnd1();
                if (endOne.getRole().equals(sourceEntitySetRole) && endOne.getEntitySet().equals(sourceEntitySetName)) {
                    return associationSet;
                }
                AssociationSetEnd endTwo = associationSet.getEnd2();
                if (!endTwo.getRole().equals(sourceEntitySetRole) || !endTwo.getEntitySet().equals(sourceEntitySetName)) continue;
                return associationSet;
            }
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName edmFQName) throws ODataException {
        Schema schema = this.namespace2Schema.get(edmFQName.getNamespace());
        if (schema != null) {
            List complexTypes = schema.getComplexTypes();
            for (ComplexType complexType : complexTypes) {
                if (!complexType.getName().equals(edmFQName.getName())) continue;
                return complexType;
            }
        }
        return null;
    }

    public EntityContainerInfo getEntityContainerInfo(String name) throws ODataException {
        EntityContainer container = this.name2Container.get(name);
        if (container == null) {
            container = this.defaultContainer;
        }
        if (container != null) {
            EntityContainerInfo info = new EntityContainerInfo();
            info.setName(container.getName());
            info.setDefaultEntityContainer(container.isDefaultEntityContainer());
            info.setExtendz(container.getExtendz());
            info.setAnnotationAttributes(container.getAnnotationAttributes());
            info.setAnnotationElements(container.getAnnotationElements());
            return info;
        }
        return null;
    }

    public EntitySet getEntitySet(String entityContainer, String name) throws ODataException {
        EntityContainer container = this.name2Container.get(entityContainer);
        if (container != null) {
            List entitySets = container.getEntitySets();
            for (EntitySet entitySet : entitySets) {
                if (!entitySet.getName().equals(name)) continue;
                return entitySet;
            }
        }
        return null;
    }

    public EntityType getEntityType(FullQualifiedName edmFQName) throws ODataException {
        Schema schema = this.namespace2Schema.get(edmFQName.getNamespace());
        if (schema != null) {
            List complexTypes = schema.getEntityTypes();
            for (EntityType complexType : complexTypes) {
                if (!complexType.getName().equals(edmFQName.getName())) continue;
                return complexType;
            }
        }
        return null;
    }

    public FunctionImport getFunctionImport(String entityContainer, String name) throws ODataException {
        EntityContainer container = this.name2Container.get(entityContainer);
        if (container != null) {
            List functionImports = container.getFunctionImports();
            for (FunctionImport functionImport : functionImports) {
                if (!functionImport.getName().equals(name)) continue;
                return functionImport;
            }
        }
        return null;
    }

    public List<Schema> getSchemas() throws ODataException {
        return new ArrayList<Schema>(this.namespace2Schema.values());
    }

    private void updateSchema(Class<?> aClass) {
        EdmComplexType ect;
        EdmEntityType et = aClass.getAnnotation(EdmEntityType.class);
        if (et != null) {
            this.updateSchema(aClass, et);
        }
        if ((ect = aClass.getAnnotation(EdmComplexType.class)) != null) {
            this.updateSchema(aClass, ect);
        }
    }

    private void updateSchema(Class<?> aClass, EdmEntityType et) {
        SchemaBuilder b = this.getSchemaBuilder(et.namespace(), aClass);
        TypeBuilder typeBuilder = TypeBuilder.init(et, aClass);
        b.addEntityType(typeBuilder.buildEntityType());
        b.addAssociations(typeBuilder.buildAssociations());
    }

    private SchemaBuilder getSchemaBuilder(String namespace, Class<?> aClass) {
        SchemaBuilder builder;
        String usedNamespace = namespace;
        if (usedNamespace.isEmpty()) {
            usedNamespace = ANNOTATION_HELPER.getCanonicalNamespace(aClass);
        }
        if ((builder = this.namespace2SchemaBuilder.get(usedNamespace)) == null) {
            builder = SchemaBuilder.init(usedNamespace);
            this.namespace2SchemaBuilder.put(usedNamespace, builder);
        }
        return builder;
    }

    private void updateSchema(Class<?> aClass, EdmComplexType et) {
        SchemaBuilder b = this.getSchemaBuilder(et.namespace(), aClass);
        TypeBuilder typeBuilder = TypeBuilder.init(et, aClass);
        b.addComplexType(typeBuilder.buildComplexType());
    }

    private void handleEntityContainer(Class<?> aClass) {
        EdmEntityType entityType = aClass.getAnnotation(EdmEntityType.class);
        if (entityType != null) {
            EdmEntitySet entitySet;
            FullQualifiedName typeName = this.createFqnForEntityType(aClass);
            String containerName = ANNOTATION_HELPER.extractContainerName(aClass);
            ContainerBuilder builder = this.containerName2ContainerBuilder.get(containerName);
            if (builder == null) {
                builder = ContainerBuilder.init(typeName.getNamespace(), containerName);
                this.containerName2ContainerBuilder.put(containerName, builder);
            }
            if ((entitySet = aClass.getAnnotation(EdmEntitySet.class)) != null) {
                builder.addEntitySet(this.createEntitySet(typeName, aClass));
            }
        }
    }

    private EntitySet createEntitySet(FullQualifiedName typeName, Class<?> entitySetClass) {
        String entitySetName = ANNOTATION_HELPER.extractEntitySetName(entitySetClass);
        return new EntitySet().setName(entitySetName).setEntityType(typeName);
    }

    private FullQualifiedName createFqnForEntityType(Class<?> annotatedClass) {
        return ANNOTATION_HELPER.extractEntityTypeFqn(annotatedClass);
    }

    private void finish() throws ODataException {
        Collection<ContainerBuilder> containers = this.containerName2ContainerBuilder.values();
        for (ContainerBuilder containerBuilder : containers) {
            SchemaBuilder schemaBuilder = this.namespace2SchemaBuilder.get(containerBuilder.getNamespace());
            containerBuilder.addAssociationSets(schemaBuilder.name2Associations.values());
            EntityContainer container = containerBuilder.build();
            schemaBuilder.addEntityContainer(container);
            this.name2Container.put(container.getName(), container);
            if (!container.isDefaultEntityContainer()) continue;
            this.defaultContainer = container;
        }
        Collection<SchemaBuilder> schemaBuilders = this.namespace2SchemaBuilder.values();
        for (SchemaBuilder schemaBuilder : schemaBuilders) {
            Schema schema = schemaBuilder.build();
            this.namespace2Schema.put(schema.getNamespace(), schema);
        }
    }

    static class SchemaBuilder {
        private final String namespace;
        private final List<Using> usings = new ArrayList<Using>();
        private final List<EntityType> entityTypes = new ArrayList<EntityType>();
        private final List<ComplexType> complexTypes = new ArrayList<ComplexType>();
        private final Map<String, Association> name2Associations = new HashMap<String, Association>();
        private final List<EntityContainer> entityContainers = new ArrayList<EntityContainer>();
        private final List<AnnotationAttribute> annotationAttributes = new ArrayList<AnnotationAttribute>();
        private final List<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();

        private SchemaBuilder(String namespace) {
            this.namespace = namespace;
        }

        public static SchemaBuilder init(String namespace) {
            return new SchemaBuilder(namespace);
        }

        public SchemaBuilder addEntityType(EntityType type) {
            this.entityTypes.add(type);
            return this;
        }

        public SchemaBuilder addEntityContainer(EntityContainer container) {
            this.entityContainers.add(container);
            return this;
        }

        public SchemaBuilder addComplexType(ComplexType createEntityType) {
            this.complexTypes.add(createEntityType);
            return this;
        }

        public void addAssociations(Collection<Association> associations) {
            for (Association association : associations) {
                String relationshipName = association.getName();
                if (this.name2Associations.containsKey(relationshipName)) {
                    association = this.mergeAssociations(this.name2Associations.get(relationshipName), association);
                }
                this.name2Associations.put(relationshipName, association);
            }
        }

        private Association mergeAssociations(Association associationOne, Association associationTwo) {
            AssociationEnd[] oneEnds;
            AssociationEnd oneEnd1 = associationOne.getEnd1();
            AssociationEnd oneEnd2 = associationOne.getEnd2();
            AssociationEnd twoEnd1 = associationTwo.getEnd1();
            AssociationEnd twoEnd2 = associationTwo.getEnd2();
            for (AssociationEnd associationEnd : oneEnds = new AssociationEnd[]{oneEnd1, oneEnd2}) {
                if (associationEnd.getRole().equals(twoEnd1.getRole())) {
                    if (twoEnd1.getMultiplicity() != EdmMultiplicity.MANY) continue;
                    associationEnd.setMultiplicity(EdmMultiplicity.MANY);
                    continue;
                }
                if (!associationEnd.getRole().equals(twoEnd2.getRole()) || twoEnd2.getMultiplicity() != EdmMultiplicity.MANY) continue;
                associationEnd.setMultiplicity(EdmMultiplicity.MANY);
            }
            return associationOne;
        }

        public Schema build() {
            Schema s = new Schema();
            s.setUsings(this.usings);
            s.setEntityTypes(this.entityTypes);
            s.setComplexTypes(this.complexTypes);
            s.setAssociations(new ArrayList<Association>(this.name2Associations.values()));
            s.setEntityContainers(this.entityContainers);
            s.setAnnotationAttributes(this.annotationAttributes);
            s.setAnnotationElements(this.annotationElements);
            s.setNamespace(this.namespace);
            return s;
        }
    }

    static class TypeBuilder {
        private final String namespace;
        private final String name;
        private boolean isAbstract = false;
        private boolean isMediaResource = false;
        private String mediaResourceMimeTypeKey;
        private String mediaResourceSourceKey;
        private FullQualifiedName baseEntityType = null;
        private final List<PropertyRef> keyProperties = new ArrayList<PropertyRef>();
        private final List<Property> properties = new ArrayList<Property>();
        private final List<NavigationProperty> navProperties = new ArrayList<NavigationProperty>();
        private final List<Association> associations = new ArrayList<Association>();

        public TypeBuilder(FullQualifiedName fqn) {
            this.namespace = fqn.getNamespace();
            this.name = fqn.getName();
        }

        public static TypeBuilder init(EdmEntityType entity, Class<?> aClass) {
            return new TypeBuilder(ANNOTATION_HELPER.extractEntityTypeFqn(entity, aClass)).withClass(aClass);
        }

        public static TypeBuilder init(EdmComplexType entity, Class<?> aClass) {
            return new TypeBuilder(ANNOTATION_HELPER.extractComplexTypeFqn(entity, aClass)).withClass(aClass);
        }

        private TypeBuilder withClass(Class<?> aClass) {
            Field[] fields;
            this.baseEntityType = this.createBaseEntityFqn(aClass);
            if (Modifier.isAbstract(aClass.getModifiers())) {
                this.isAbstract = true;
            }
            for (Field field : fields = aClass.getDeclaredFields()) {
                EdmMediaResourceContent emrc;
                EdmNavigationProperty enp;
                EdmProperty ep = field.getAnnotation(EdmProperty.class);
                if (ep != null) {
                    EdmMediaResourceSource emrs;
                    EdmMediaResourceMimeType emrmt;
                    Property property = this.createProperty(ep, field);
                    this.properties.add(property);
                    EdmKey eti = field.getAnnotation(EdmKey.class);
                    if (eti != null) {
                        this.keyProperties.add(this.createKeyProperty(ep, field));
                    }
                    if ((emrmt = field.getAnnotation(EdmMediaResourceMimeType.class)) != null) {
                        this.mediaResourceMimeTypeKey = property.getName();
                    }
                    if ((emrs = field.getAnnotation(EdmMediaResourceSource.class)) != null) {
                        this.mediaResourceSourceKey = property.getName();
                    }
                }
                if ((enp = field.getAnnotation(EdmNavigationProperty.class)) != null) {
                    Class<?> fromClass = field.getDeclaringClass();
                    Class<?> toClass = ClassHelper.getFieldType(field);
                    AnnotationHelper.AnnotatedNavInfo info = ANNOTATION_HELPER.getCommonNavigationInfo(fromClass, toClass);
                    NavigationProperty navProperty = this.createNavigationProperty(this.namespace, field, info);
                    this.navProperties.add(navProperty);
                    Association association = this.createAssociation(info);
                    this.associations.add(association);
                }
                if ((emrc = field.getAnnotation(EdmMediaResourceContent.class)) == null) continue;
                this.isMediaResource = true;
            }
            return this;
        }

        public TypeBuilder addProperty(PropertyRef property) {
            this.keyProperties.add(property);
            return this;
        }

        public TypeBuilder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        public TypeBuilder addNavigationProperty(NavigationProperty property) {
            this.navProperties.add(property);
            return this;
        }

        public TypeBuilder setAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public ComplexType buildComplexType() {
            ComplexType complexType = new ComplexType();
            if (this.baseEntityType != null) {
                complexType.setBaseType(this.baseEntityType);
            }
            return complexType.setName(this.name).setProperties(this.properties);
        }

        public EntityType buildEntityType() {
            EntityType entityType = new EntityType();
            if (this.baseEntityType != null) {
                entityType.setBaseType(this.baseEntityType);
            }
            if (!this.keyProperties.isEmpty()) {
                entityType.setKey(new Key().setKeys(this.keyProperties));
            }
            if (!this.navProperties.isEmpty()) {
                entityType.setNavigationProperties(this.navProperties);
            }
            return entityType.setName(this.name).setAbstract(this.isAbstract).setHasStream(this.isMediaResource).setProperties(this.properties).setMapping(new Mapping().setMediaResourceMimeTypeKey(this.mediaResourceMimeTypeKey).setMediaResourceSourceKey(this.mediaResourceSourceKey));
        }

        public Collection<Association> buildAssociations() {
            return Collections.unmodifiableCollection(this.associations);
        }

        private PropertyRef createKeyProperty(EdmProperty et, Field field) {
            PropertyRef keyProperty = new PropertyRef();
            String entityName = et.name();
            if (entityName.isEmpty()) {
                entityName = this.getCanonicalName(field);
            }
            return keyProperty.setName(entityName);
        }

        private Property createProperty(EdmProperty ep, Field field) {
            if (this.isAnnotatedEntity(field.getType())) {
                return this.createComplexProperty(ep, field);
            }
            return this.createSimpleProperty(ep, field);
        }

        private Property createSimpleProperty(EdmProperty ep, Field field) {
            SimpleProperty sp = new SimpleProperty();
            String entityName = ANNOTATION_HELPER.getPropertyName(field);
            sp.setName(entityName);
            EdmType type = ep.type();
            if (type == EdmType.NULL) {
                type = this.getEdmType(field.getType());
            }
            sp.setType(ANNOTATION_HELPER.mapTypeKind(type));
            sp.setFacets((EdmFacets)this.createFacets(ep.facets(), field.getAnnotation(EdmConcurrencyControl.class)));
            return sp;
        }

        private Facets createFacets(org.apache.olingo.odata2.api.annotation.edm.EdmFacets facets, EdmConcurrencyControl concurrencyControl) {
            Facets resultFacets = new Facets().setNullable(Boolean.valueOf(facets.nullable()));
            if (facets.maxLength() > -1) {
                resultFacets.setMaxLength(Integer.valueOf(facets.maxLength()));
            }
            if (facets.precision() > -1) {
                resultFacets.setPrecision(Integer.valueOf(facets.precision()));
            }
            if (facets.scale() > -1) {
                resultFacets.setScale(Integer.valueOf(facets.scale()));
            }
            if (concurrencyControl != null) {
                resultFacets.setConcurrencyMode(EdmConcurrencyMode.Fixed);
            }
            return resultFacets;
        }

        private Property createComplexProperty(EdmProperty ep, Field field) {
            ComplexProperty cp = new ComplexProperty();
            String entityName = ANNOTATION_HELPER.getPropertyName(field);
            cp.setName(entityName);
            FullQualifiedName fqn = ANNOTATION_HELPER.extractComplexTypeFqn(field.getType());
            cp.setType(fqn);
            cp.setFacets((EdmFacets)this.createFacets(ep.facets(), field.getAnnotation(EdmConcurrencyControl.class)));
            return cp;
        }

        private NavigationProperty createNavigationProperty(String namespace, Field field, AnnotationHelper.AnnotatedNavInfo navInfo) {
            NavigationProperty navProp = new NavigationProperty();
            navProp.setName(ANNOTATION_HELPER.getPropertyName(field));
            String fromRole = navInfo.getFromRoleName();
            navProp.setFromRole(fromRole);
            navProp.setToRole(navInfo.getToRoleName());
            String relationshipName = navInfo.getRelationshipName();
            navProp.setRelationship(new FullQualifiedName(namespace, relationshipName));
            return navProp;
        }

        private EdmType getEdmType(Class<?> type) {
            if (type == String.class) {
                return EdmType.STRING;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return EdmType.BOOLEAN;
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return EdmType.SBYTE;
            }
            if (type == Short.TYPE || type == Short.class) {
                return EdmType.INT16;
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return EdmType.INT32;
            }
            if (type == Long.TYPE || type == Long.class) {
                return EdmType.INT64;
            }
            if (type == Double.TYPE || type == Double.class) {
                return EdmType.DOUBLE;
            }
            if (type == Float.TYPE || type == Float.class) {
                return EdmType.SINGLE;
            }
            if (type == BigInteger.class || type == BigDecimal.class) {
                return EdmType.DECIMAL;
            }
            if (type == Byte[].class || type == byte[].class) {
                return EdmType.BINARY;
            }
            if (type == Date.class) {
                return EdmType.DATE_TIME;
            }
            if (type == Calendar.class) {
                return EdmType.DATE_TIME_OFFSET;
            }
            if (type == UUID.class) {
                return EdmType.GUID;
            }
            throw new UnsupportedOperationException("Not yet supported type '" + type + "'.");
        }

        private Class<?> checkForBaseEntityClass(Class<?> aClass) {
            Class<?> superClass = aClass.getSuperclass();
            if (superClass == Object.class) {
                return null;
            }
            EdmEntityType edmEntity = superClass.getAnnotation(EdmEntityType.class);
            if (edmEntity == null) {
                return this.checkForBaseEntityClass(superClass);
            }
            return superClass;
        }

        private FullQualifiedName createBaseEntityFqn(Class<?> aClass) {
            Class<?> baseEntityClass = this.checkForBaseEntityClass(aClass);
            if (baseEntityClass == null) {
                return null;
            }
            return ANNOTATION_HELPER.extractEntityTypeFqn(baseEntityClass);
        }

        private Association createAssociation(AnnotationHelper.AnnotatedNavInfo info) {
            Association association = new Association();
            AssociationEnd fromEnd = new AssociationEnd();
            fromEnd.setRole(info.getFromRoleName());
            fromEnd.setType(new FullQualifiedName(this.namespace, info.getFromTypeName()));
            fromEnd.setMultiplicity(info.getFromMultiplicity());
            association.setEnd1(fromEnd);
            AssociationEnd toEnd = new AssociationEnd();
            toEnd.setRole(info.getToRoleName());
            toEnd.setType(new FullQualifiedName(this.namespace, info.getToTypeName()));
            toEnd.setMultiplicity(info.getToMultiplicity());
            association.setEnd2(toEnd);
            String associationName = info.getRelationshipName();
            association.setName(associationName);
            return association;
        }

        private String getCanonicalName(Field field) {
            return ANNOTATION_HELPER.getCanonicalName(field);
        }

        private boolean isAnnotatedEntity(Class<?> clazz) {
            return ANNOTATION_HELPER.isEdmTypeAnnotated(clazz);
        }
    }

    private static class ContainerBuilder {
        private final String name;
        private final String namespace;
        private boolean defaultContainer = true;
        private final List<EntitySet> entitySets = new ArrayList<EntitySet>();
        private final List<AssociationSet> associationSets = new ArrayList<AssociationSet>();
        private final List<FunctionImport> functionImports = new ArrayList<FunctionImport>();

        private ContainerBuilder(String namespace, String containerName) {
            this.namespace = namespace;
            this.name = containerName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public static ContainerBuilder init(String namespace, String containerName) {
            return new ContainerBuilder(namespace, containerName);
        }

        public ContainerBuilder addEntitySet(EntitySet entitySet) {
            this.entitySets.add(entitySet);
            return this;
        }

        public void addAssociationSets(Collection<Association> associations) throws ODataException {
            for (Association association : associations) {
                AssociationSet as = new AssociationSet();
                as.setName(association.getName());
                FullQualifiedName asAssociationFqn = new FullQualifiedName(this.namespace, association.getName());
                as.setAssociation(asAssociationFqn);
                AssociationSetEnd asEnd1 = new AssociationSetEnd();
                asEnd1.setEntitySet(this.getEntitySetName(association.getEnd1()));
                asEnd1.setRole(association.getEnd1().getRole());
                as.setEnd1(asEnd1);
                AssociationSetEnd asEnd2 = new AssociationSetEnd();
                asEnd2.setEntitySet(this.getEntitySetName(association.getEnd2()));
                asEnd2.setRole(association.getEnd2().getRole());
                as.setEnd2(asEnd2);
                this.associationSets.add(as);
            }
        }

        public EntityContainer build() {
            EntityContainer ec = new EntityContainer();
            ec.setName(this.name);
            ec.setDefaultEntityContainer(this.defaultContainer);
            ec.setEntitySets(this.entitySets);
            ec.setAssociationSets(this.associationSets);
            ec.setFunctionImports(this.functionImports);
            return ec;
        }

        private String getEntitySetName(AssociationEnd end) throws ODataException {
            for (EntitySet entitySet : this.entitySets) {
                if (!entitySet.getEntityType().equals((Object)end.getType())) continue;
                return entitySet.getName();
            }
            throw new ODataException("No entity set found for " + end.getType());
        }
    }
}

