/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import java.net.MalformedURLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.net.URLNormalizer;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.util.AbstractChecker;
import org.apache.nutch.util.NutchConfiguration;

public class URLNormalizerChecker
extends AbstractChecker {
    private String scope = "default";
    URLNormalizers normalizers;

    public int run(String[] args) throws Exception {
        this.usage = "Usage: URLNormalizerChecker [-Dproperty=value]... [-normalizer <normalizerName>] [-scope <scope>] (-stdin | -listen <port> [-keepClientCnxOpen])\n\n  -normalizer\tURL normalizer plugin (eg. urlnormalizer-basic) to check,\n             \t(if not given all configured URL normalizers are applied)\n  -scope     \tone of: default,partition,generate_host_count,fetcher,crawldb,linkdb,inject,outlink\n  -stdin     \ttool reads a list of URLs from stdin, one URL per line\n  -listen <port>\trun tool as Telnet server listening on <port>\n\nAn empty line is added to the output if a URL fails to normalize (MalformedURLException or null returned).\n";
        if (args.length < 1) {
            System.err.println(this.usage);
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-normalizer")) {
                this.getConf().set("plugin.includes", args[++i]);
                continue;
            }
            if (args[i].equals("-scope")) {
                this.scope = args[++i];
                continue;
            }
            int numConsumed = super.parseArgs(args, i);
            if (numConsumed > 0) {
                i += numConsumed - 1;
                continue;
            }
            System.err.println("ERROR: Not a recognized argument: " + args[i]);
            System.err.println(this.usage);
            return -1;
        }
        this.normalizers = new URLNormalizers(this.getConf(), this.scope);
        System.out.print("Checking combination of these URLNormalizers: ");
        for (URLNormalizer normalizer : this.normalizers.getURLNormalizers(this.scope)) {
            System.out.print(normalizer.getClass().getSimpleName() + " ");
        }
        System.out.println("");
        return super.run();
    }

    @Override
    protected int process(String line, StringBuilder output) throws Exception {
        try {
            String norm = this.normalizers.normalize(line, this.scope);
            if (norm == null) {
                output.append("");
            } else {
                output.append(norm);
            }
        }
        catch (MalformedURLException e) {
            output.append("");
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new URLNormalizerChecker(), (String[])args);
        System.exit(res);
    }
}

