/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.http;

import java.io.PrintStream;
import java.nio.charset.Charset;
import org.archive.format.http.HttpHeaderObserver;

public class DumpingHTTPParseObserver
implements HttpHeaderObserver {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private PrintStream ps = null;

    public DumpingHTTPParseObserver() {
        this.ps = System.out;
    }

    public DumpingHTTPParseObserver(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public void headerParsed(byte[] name, int ns, int nl, byte[] value, int vs, int vl) {
        this.ps.format("headerParsed:(%d:%d)(%s)(%d:%d)(%s)\n", ns, nl, new String(name, 0, nl, UTF8), vs, vl, new String(value, 0, vl, UTF8));
    }

    @Override
    public void headersComplete(int bytesRead) {
        this.ps.format("headersComplete(%d)\n", bytesRead);
    }

    @Override
    public void headersCorrupt() {
        this.ps.println("headersCorrupted\n");
    }
}

