/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.selenium;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWebClient {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static WebDriver getDriverForPage(String url, Configuration conf) {
        WebDriver driver = null;
        long pageLoadWait = conf.getLong("page.load.delay", 3L);
        try {
            String driverType = conf.get("selenium.driver", "firefox");
            boolean enableHeadlessMode = conf.getBoolean("selenium.enable.headless", false);
            block6 : switch (driverType) {
                case "firefox": {
                    String geckoDriverPath = conf.get("selenium.grid.binary", "/root/geckodriver");
                    driver = HttpWebClient.createFirefoxWebDriver(geckoDriverPath, enableHeadlessMode);
                    break;
                }
                case "chrome": {
                    String chromeDriverPath = conf.get("selenium.grid.binary", "/root/chromedriver");
                    driver = HttpWebClient.createChromeWebDriver(chromeDriverPath, enableHeadlessMode);
                    break;
                }
                case "remote": {
                    String seleniumGridDriver;
                    String seleniumHubHost = conf.get("selenium.hub.host", "localhost");
                    int seleniumHubPort = Integer.parseInt(conf.get("selenium.hub.port", "4444"));
                    String seleniumHubPath = conf.get("selenium.hub.path", "/wd/hub");
                    String seleniumHubProtocol = conf.get("selenium.hub.protocol", "http");
                    URL seleniumHubUrl = new URL(seleniumHubProtocol, seleniumHubHost, seleniumHubPort, seleniumHubPath);
                    switch (seleniumGridDriver = conf.get("selenium.grid.driver", "firefox")) {
                        case "firefox": {
                            driver = HttpWebClient.createFirefoxRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
                            break block6;
                        }
                        case "chrome": {
                            driver = HttpWebClient.createChromeRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
                            break block6;
                        }
                        case "random": {
                            driver = HttpWebClient.createRandomRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
                            break block6;
                        }
                    }
                    LOG.error("The Selenium Grid WebDriver choice {} is not available... defaulting to FirefoxDriver().", (Object)driverType);
                    driver = HttpWebClient.createDefaultRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
                    break;
                }
                default: {
                    LOG.error("The Selenium WebDriver choice {} is not available... defaulting to FirefoxDriver().", (Object)driverType);
                    FirefoxOptions options = new FirefoxOptions();
                    driver = new FirefoxDriver(options);
                }
            }
            LOG.debug("Selenium {} WebDriver selected.", (Object)driverType);
            driver.manage().window().maximize();
            driver.manage().deleteAllCookies();
            driver.manage().timeouts().pageLoadTimeout(Duration.of(pageLoadWait, ChronoUnit.SECONDS));
            driver.get(url);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                LOG.error("Selenium WebDriver: Timeout Exception: Capturing whatever loaded so far...");
                return driver;
            }
            LOG.error(e.toString());
            HttpWebClient.cleanUpDriver(driver);
            throw new RuntimeException(e);
        }
        return driver;
    }

    public static WebDriver createFirefoxWebDriver(String firefoxDriverPath, boolean enableHeadlessMode) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setBinary(firefoxDriverPath);
        if (enableHeadlessMode) {
            firefoxOptions.addArguments(new String[]{"-headless"});
        }
        return new FirefoxDriver(firefoxOptions);
    }

    public static WebDriver createChromeWebDriver(String chromeDriverPath, boolean enableHeadlessMode) {
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--no-sandbox"});
        chromeOptions.addArguments(new String[]{"--disable-extensions"});
        chromeOptions.setBinary(chromeDriverPath);
        if (enableHeadlessMode) {
            chromeOptions.addArguments(new String[]{"--headless=new"});
        }
        return new ChromeDriver(chromeOptions);
    }

    public static RemoteWebDriver createFirefoxRemoteWebDriver(URL seleniumHubUrl, boolean enableHeadlessMode) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        if (enableHeadlessMode) {
            firefoxOptions.addArguments(new String[]{"-headless"});
        }
        return new RemoteWebDriver(seleniumHubUrl, (Capabilities)firefoxOptions);
    }

    public static RemoteWebDriver createChromeRemoteWebDriver(URL seleniumHubUrl, boolean enableHeadlessMode) {
        ChromeOptions chromeOptions = new ChromeOptions();
        if (enableHeadlessMode) {
            chromeOptions.addArguments(new String[]{"--headless=new"});
        }
        return new RemoteWebDriver(seleniumHubUrl, (Capabilities)chromeOptions);
    }

    public static RemoteWebDriver createRandomRemoteWebDriver(URL seleniumHubUrl, boolean enableHeadlessMode) {
        Random r = new Random();
        int max = 1;
        int min = 0;
        int num = r.nextInt(max - min + 1) + min;
        if (num == 0) {
            return HttpWebClient.createFirefoxRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
        }
        return HttpWebClient.createChromeRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
    }

    public static RemoteWebDriver createDefaultRemoteWebDriver(URL seleniumHubUrl, boolean enableHeadlessMode) {
        return HttpWebClient.createFirefoxRemoteWebDriver(seleniumHubUrl, enableHeadlessMode);
    }

    public static void cleanUpDriver(WebDriver driver) {
        if (driver != null) {
            try {
                driver.quit();
                TemporaryFilesystem.getDefaultTmpFS().deleteTemporaryFiles();
            }
            catch (Exception e) {
                LOG.error(e.toString());
            }
        }
    }

    public static String getHtmlPage(String url, Configuration conf) {
        WebDriver driver = HttpWebClient.getDriverForPage(url, conf);
        try {
            if (conf.getBoolean("take.screenshot", false)) {
                HttpWebClient.takeScreenshot(driver, conf);
            }
            String string = driver.getPageSource();
            return string;
        }
        catch (Exception e) {
            TemporaryFilesystem.getDefaultTmpFS().deleteTemporaryFiles();
            LOG.error("getHtmlPage(url, conf): {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        finally {
            HttpWebClient.cleanUpDriver(driver);
        }
    }

    public static String getHtmlPage(String url) {
        return HttpWebClient.getHtmlPage(url, null);
    }

    private static void takeScreenshot(WebDriver driver, Configuration conf) {
        try {
            String url = driver.getCurrentUrl();
            File srcFile = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            LOG.debug("In-memory screenshot taken of: {}", (Object)url);
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (conf.get("screenshot.location") != null) {
                String screenshotPath = conf.get("screenshot.location", "");
                Path path = new Path(String.valueOf(new File(screenshotPath, srcFile.getName())));
                FSDataOutputStream os = null;
                if (!fs.exists(path)) {
                    LOG.debug("No existing screenshot already exists... creating new file at {}/{}.", (Object)screenshotPath, (Object)srcFile.getName());
                    os = fs.create(path);
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(srcFile));
                IOUtils.copyBytes((InputStream)is, (OutputStream)os, (Configuration)conf);
                LOG.debug("Screenshot for {} successfully saved to: {}/{}", new Object[]{url, screenshotPath, srcFile.getName()});
            } else {
                LOG.warn("Screenshot for {} not saved to HDFS (subsequently discarded) as value for 'screenshot.location' is absent from nutch-site.xml.", (Object)url);
            }
        }
        catch (Exception e) {
            LOG.error("Error taking screenshot: ", (Throwable)e);
            HttpWebClient.cleanUpDriver(driver);
            throw new RuntimeException(e);
        }
    }
}

