/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FilenameUtils;
import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.ShutdownHook;
import org.apache.nifi.minifi.bootstrap.Status;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.exception.StartupFailureException;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiExecCommandProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiListener;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiPropertiesGenerator;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStdLogHandler;
import org.apache.nifi.minifi.bootstrap.service.PeriodicStatusReporterManager;
import org.apache.nifi.minifi.commons.api.MiNiFiCommandState;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.properties.BootstrapProperties;

public class StartRunner
implements CommandRunner {
    private static final int STARTUP_WAIT_SECONDS = 60;
    private final CurrentPortProvider currentPortProvider;
    private final BootstrapFileProvider bootstrapFileProvider;
    private final PeriodicStatusReporterManager periodicStatusReporterManager;
    private final MiNiFiStdLogHandler miNiFiStdLogHandler;
    private final MiNiFiParameters miNiFiParameters;
    private final File bootstrapConfigFile;
    private final Lock lock = new ReentrantLock();
    private final Condition startupCondition = this.lock.newCondition();
    private final RunMiNiFi runMiNiFi;
    private final MiNiFiExecCommandProvider miNiFiExecCommandProvider;
    private final ConfigurationChangeListener configurationChangeListener;
    private final MiNiFiPropertiesGenerator miNiFiPropertiesGenerator;
    private volatile ShutdownHook shutdownHook;
    private int listenPort;

    public StartRunner(CurrentPortProvider currentPortProvider, BootstrapFileProvider bootstrapFileProvider, PeriodicStatusReporterManager periodicStatusReporterManager, MiNiFiStdLogHandler miNiFiStdLogHandler, MiNiFiParameters miNiFiParameters, File bootstrapConfigFile, RunMiNiFi runMiNiFi, MiNiFiExecCommandProvider miNiFiExecCommandProvider, ConfigurationChangeListener configurationChangeListener) {
        this.currentPortProvider = currentPortProvider;
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.periodicStatusReporterManager = periodicStatusReporterManager;
        this.miNiFiStdLogHandler = miNiFiStdLogHandler;
        this.miNiFiParameters = miNiFiParameters;
        this.bootstrapConfigFile = bootstrapConfigFile;
        this.runMiNiFi = runMiNiFi;
        this.miNiFiExecCommandProvider = miNiFiExecCommandProvider;
        this.configurationChangeListener = configurationChangeListener;
        this.miNiFiPropertiesGenerator = new MiNiFiPropertiesGenerator();
    }

    @Override
    public int runCommand(String[] args) {
        try {
            this.start();
        }
        catch (Exception e) {
            RunMiNiFi.CMD_LOGGER.error("Exception happened during MiNiFi startup", (Throwable)e);
            return Status.ERROR.getStatusCode();
        }
        return Status.OK.getStatusCode();
    }

    private void start() throws IOException, InterruptedException, ConfigurationChangeException {
        Integer port = this.currentPortProvider.getCurrentPort();
        if (port != null) {
            RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi is already running, listening to Bootstrap on port {}", (Object)port);
            return;
        }
        File prevLockFile = this.bootstrapFileProvider.getLockFile();
        if (prevLockFile.exists() && !prevLockFile.delete()) {
            RunMiNiFi.CMD_LOGGER.warn("Failed to delete previous lock file {}; this file should be cleaned up manually", (Object)prevLockFile);
        }
        BootstrapProperties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
        String confDir = bootstrapProperties.getProperty("conf.dir");
        this.generateMiNiFiProperties(this.bootstrapFileProvider.getProtectedBootstrapProperties(), confDir);
        this.regenerateFlowConfiguration(bootstrapProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_CONFIG.getKey()));
        Process process = this.startMiNiFi(bootstrapProperties);
        try {
            while (true) {
                if (process.isAlive()) {
                    this.handleReload();
                    continue;
                }
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException ise) {
                    RunMiNiFi.DEFAULT_LOGGER.trace("The virtual machine is already in the process of shutting down", (Throwable)ise);
                }
                if (this.runMiNiFi.isAutoRestartNiFi().booleanValue() && this.needRestart()) {
                    File reloadFile = this.bootstrapFileProvider.getReloadLockFile();
                    if (reloadFile.exists()) {
                        RunMiNiFi.DEFAULT_LOGGER.info("Currently reloading configuration. Will wait to restart MiNiFi.");
                        Thread.sleep(5000L);
                        continue;
                    }
                    process = this.restartMiNifi(confDir);
                    if (process == null) {
                        return;
                    }
                } else {
                    return;
                }
            }
        }
        finally {
            this.miNiFiStdLogHandler.shutdown();
            this.runMiNiFi.shutdownChangeNotifier();
            this.periodicStatusReporterManager.shutdownPeriodicStatusReporters();
        }
    }

    private Process restartMiNifi(String confDir) throws IOException {
        boolean previouslyStarted = this.runMiNiFi.isNiFiStarted();
        boolean configChangeSuccessful = true;
        if (!previouslyStarted) {
            File bootstrapSwapConfigFile = this.bootstrapFileProvider.getBootstrapConfSwapFile();
            if (bootstrapSwapConfigFile.exists()) {
                if (!this.revertBootstrapConfig(confDir, bootstrapSwapConfigFile)) {
                    return null;
                }
            } else {
                RunMiNiFi.DEFAULT_LOGGER.info("MiNiFi either never started or failed to restart. Will not attempt to restart MiNiFi");
                return null;
            }
            configChangeSuccessful = false;
        } else {
            this.runMiNiFi.setNiFiStarted(false);
        }
        this.miNiFiParameters.setSecretKey(null);
        RunMiNiFi.CMD_LOGGER.info("Restarting Apache MiNiFi...");
        Process process = this.startMiNiFiProcess(this.getProcessBuilder());
        boolean started = this.waitForStart();
        long pid = process.pid();
        if (started) {
            this.runMiNiFi.sendAcknowledgeToMiNiFi(configChangeSuccessful ? MiNiFiCommandState.FULLY_APPLIED : MiNiFiCommandState.NOT_APPLIED_WITH_RESTART);
            RunMiNiFi.DEFAULT_LOGGER.info("Application Process [{}] started", (Object)pid);
        } else {
            RunMiNiFi.DEFAULT_LOGGER.info("Application Process [{}] not started", (Object)pid);
        }
        return process;
    }

    private boolean revertBootstrapConfig(String confDir, File bootstrapSwapConfigFile) throws IOException {
        RunMiNiFi.DEFAULT_LOGGER.info("Bootstrap Swap file exists, MiNiFi failed trying to change configuration. Reverting to old configuration.");
        Files.copy(bootstrapSwapConfigFile.toPath(), this.bootstrapConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        try {
            this.miNiFiPropertiesGenerator.generateMinifiProperties(confDir, this.bootstrapFileProvider.getBootstrapProperties());
        }
        catch (ConfigurationChangeException e) {
            RunMiNiFi.DEFAULT_LOGGER.error("Unable to create MiNiFi properties file. Will not attempt to restart MiNiFi. Swap File should be cleaned up manually.");
            return false;
        }
        if (!bootstrapSwapConfigFile.delete()) {
            RunMiNiFi.DEFAULT_LOGGER.warn("The bootstrap swap file failed to delete after replacing using it to revert to the old configuration. It should be cleaned up manually.");
        }
        this.runMiNiFi.setReloading(false);
        return true;
    }

    private boolean needRestart() throws IOException {
        boolean needRestart = true;
        File statusFile = this.bootstrapFileProvider.getStatusFile();
        if (!statusFile.exists()) {
            RunMiNiFi.DEFAULT_LOGGER.info("Status File no longer exists. Will not restart MiNiFi");
            return false;
        }
        File lockFile = this.bootstrapFileProvider.getLockFile();
        if (lockFile.exists()) {
            RunMiNiFi.DEFAULT_LOGGER.info("A shutdown was initiated. Will not restart MiNiFi");
            return false;
        }
        return needRestart;
    }

    private void handleReload() {
        try {
            Thread.sleep(1000L);
            if (this.runMiNiFi.getReloading() && this.runMiNiFi.isNiFiStarted()) {
                this.deleteSwapFile(this.bootstrapFileProvider.getBootstrapConfSwapFile());
                this.runMiNiFi.setReloading(false);
            }
        }
        catch (InterruptedException ie) {
            RunMiNiFi.DEFAULT_LOGGER.warn("Thread interrupted while handling reload");
        }
    }

    private void deleteSwapFile(File file) {
        if (file.exists()) {
            RunMiNiFi.DEFAULT_LOGGER.info("MiNiFi has finished reloading successfully and {} file exists. Deleting old configuration.", (Object)file.getName());
            if (file.delete()) {
                RunMiNiFi.DEFAULT_LOGGER.info("Swap file ({}) was successfully deleted.", (Object)file.getName());
            } else {
                RunMiNiFi.DEFAULT_LOGGER.error("Swap file ({}) was not deleted. It should be deleted manually.", (Object)file.getAbsoluteFile());
            }
        }
    }

    private void generateMiNiFiProperties(BootstrapProperties bootstrapProperties, String confDir) {
        RunMiNiFi.DEFAULT_LOGGER.debug("Generating minifi.properties from bootstrap.conf");
        try {
            this.miNiFiPropertiesGenerator.generateMinifiProperties(confDir, bootstrapProperties);
        }
        catch (ConfigurationChangeException e) {
            throw new StartupFailureException("Unable to create MiNiFi properties file", e);
        }
    }

    private void regenerateFlowConfiguration(String flowConfigFileLocation) throws ConfigurationChangeException, IOException {
        Path flowConfigFile = Path.of(flowConfigFileLocation, new String[0]).toAbsolutePath();
        String currentFlowConfigFileBaseName = FilenameUtils.getBaseName((String)flowConfigFile.toString());
        Path rawConfigFile = flowConfigFile.getParent().resolve(currentFlowConfigFileBaseName + ".raw");
        if (Files.exists(rawConfigFile, new LinkOption[0])) {
            RunMiNiFi.DEFAULT_LOGGER.debug("Regenerating flow configuration {} from raw flow configuration {}", (Object)flowConfigFile, (Object)rawConfigFile);
            this.configurationChangeListener.handleChange(Files.newInputStream(rawConfigFile, new OpenOption[0]));
        }
    }

    private Process startMiNiFi(BootstrapProperties bootstrapProperties) throws IOException {
        int bootstrapListenPort = this.parseBootstrapListenPort(bootstrapProperties);
        MiNiFiListener listener = new MiNiFiListener();
        this.listenPort = listener.start(this.runMiNiFi, bootstrapListenPort, this.bootstrapFileProvider, this.configurationChangeListener);
        RunMiNiFi.CMD_LOGGER.info("Starting Apache MiNiFi...");
        return this.startMiNiFiProcess(this.getProcessBuilder());
    }

    private int parseBootstrapListenPort(BootstrapProperties bootstrapProperties) {
        String bootstrapListenPort = bootstrapProperties.getProperty("nifi.bootstrap.listen.port");
        int parsedBootstrapListenPort = Optional.ofNullable(bootstrapListenPort).map(String::trim).map(port -> {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse Bootstrap listen port, please provide a valid port for nifi.bootstrap.listen.port");
            }
        }).orElse(0);
        RunMiNiFi.CMD_LOGGER.info("Boostrap listen port {}", (Object)parsedBootstrapListenPort);
        return parsedBootstrapListenPort;
    }

    private ProcessBuilder getProcessBuilder() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        File workingDir = this.getWorkingDir();
        List<String> cmd = this.miNiFiExecCommandProvider.getMiNiFiExecCommand(this.listenPort, workingDir);
        builder.command(cmd);
        builder.directory(workingDir);
        RunMiNiFi.CMD_LOGGER.debug("Working Directory: {}", (Object)workingDir.getAbsolutePath());
        RunMiNiFi.CMD_LOGGER.info("Command: {}", (Object)String.join((CharSequence)" ", cmd));
        return builder;
    }

    private Process startMiNiFiProcess(ProcessBuilder builder) throws IOException {
        Process process = builder.start();
        this.miNiFiStdLogHandler.initLogging(process);
        this.miNiFiParameters.setMiNiFiPort(-1);
        this.miNiFiParameters.setMinifiPid(-1L);
        long pid = process.pid();
        this.miNiFiParameters.setMinifiPid(pid);
        Properties minifiProps = new Properties();
        minifiProps.setProperty("pid", String.valueOf(pid));
        this.bootstrapFileProvider.saveStatusProperties(minifiProps);
        this.shutdownHook = new ShutdownHook(this.runMiNiFi, this.miNiFiStdLogHandler);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        return process;
    }

    private File getWorkingDir() throws IOException {
        BootstrapProperties props = this.bootstrapFileProvider.getBootstrapProperties();
        File bootstrapConfigAbsoluteFile = this.bootstrapConfigFile.getAbsoluteFile();
        File binDir = bootstrapConfigAbsoluteFile.getParentFile();
        return Optional.ofNullable(props.getProperty("working.dir")).map(File::new).orElse(binDir.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForStart() {
        this.lock.lock();
        try {
            long startTime = System.nanoTime();
            while (this.miNiFiParameters.getMinifiPid() < 1L && this.miNiFiParameters.getMiNiFiPort() < 1 || !this.runMiNiFi.isNiFiStarted()) {
                RunMiNiFi.DEFAULT_LOGGER.debug("Waiting MiNiFi to start Pid={}, port={}, isNifiStarted={}", new Object[]{this.miNiFiParameters.getMinifiPid(), this.miNiFiParameters.getMiNiFiPort(), this.runMiNiFi.isNiFiStarted()});
                try {
                    this.startupCondition.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    boolean bl = false;
                    this.lock.unlock();
                    return bl;
                }
                long waitNanos = System.nanoTime() - startTime;
                long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
                if (waitSeconds <= 60L) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }
}

