/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.component.LifeCycle;

@ManagedObject(value="The container of HTTP/2 sessions")
public class SessionContainer
extends AbstractLifeCycle
implements Connection.Listener,
Graceful,
Dumpable {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<Session> sessions = ConcurrentHashMap.newKeySet();
    private CompletableFuture<Void> shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpened(Connection connection) {
        boolean isShutDown;
        HTTP2Session session = ((HTTP2Connection)connection).getSession();
        this.lock.readLock().lock();
        try {
            boolean bl = isShutDown = this.shutdown != null;
            if (!isShutDown) {
                this.sessions.add(session);
                LifeCycle.start((Object)session);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (isShutDown) {
            session.shutdown();
        }
    }

    public void onClosed(Connection connection) {
        this.lock.readLock().lock();
        try {
            HTTP2Session session = ((HTTP2Connection)connection).getSession();
            if (this.sessions.remove(session)) {
                LifeCycle.stop((Object)session);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Void> shutdown() {
        this.lock.writeLock().lock();
        try {
            if (this.shutdown != null) {
                CompletableFuture<Void> completableFuture = this.shutdown;
                return completableFuture;
            }
            CompletableFuture[] shutdowns = (CompletableFuture[])this.sessions.stream().map(Session::shutdown).toArray(CompletableFuture[]::new);
            this.shutdown = CompletableFuture.allOf(shutdowns);
            CompletableFuture<Void> completableFuture = this.shutdown;
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isShutdown() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.shutdown != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Session> getSessions() {
        return Collections.unmodifiableSet(this.sessions);
    }

    public int getSize() {
        return this.sessions.size();
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{new DumpableCollection("sessions", this.sessions)});
    }

    public String toString() {
        return String.format("%s@%x[size=%d]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getSize());
    }
}

