/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.innosetup;

import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import org.apache.netbeans.nbpackage.Template;
import org.apache.netbeans.nbpackage.innosetup.InnoSetupTask;

public class InnoSetupPackager
implements Packager {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle(InnoSetupPackager.class.getPackageName() + ".Messages");
    static final Option<Path> TOOL_PATH = Option.ofPath("package.innosetup.tool", "", MESSAGES.getString("option.tool.help"));
    static final Option<String> APPID = Option.ofString("package.innosetup.appid", "", MESSAGES.getString("option.appid.help"));
    static final Option<Path> ICON_PATH = Option.ofPath("package.innosetup.icon", "", MESSAGES.getString("option.icon.help"));
    static final Option<Path> LICENSE_PATH = Option.ofPath("package.innosetup.license", "", MESSAGES.getString("option.license.help"));
    static final Option<Path> ISS_TEMPLATE_PATH = Option.ofPath("package.innosetup.template", "", MESSAGES.getString("option.template.help"));
    static final Template ISS_TEMPLATE = Template.of(ISS_TEMPLATE_PATH, "InnoSetup.iss.template", () -> InnoSetupPackager.class.getResourceAsStream("InnoSetup.iss.template"));
    private static final List<Option<?>> INNOSETUP_OPTIONS = List.of(TOOL_PATH, APPID, ICON_PATH, LICENSE_PATH, ISS_TEMPLATE_PATH);
    private static final List<Template> INNOSETUP_TEMPLATES = List.of(ISS_TEMPLATE);

    @Override
    public Packager.Task createTask(ExecutionContext context) {
        return new InnoSetupTask(context);
    }

    @Override
    public String name() {
        return "windows-innosetup";
    }

    @Override
    public Stream<Option<?>> options() {
        return INNOSETUP_OPTIONS.stream();
    }

    @Override
    public Stream<Template> templates() {
        return INNOSETUP_TEMPLATES.stream();
    }
}

