/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeSelect;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNodeRenderer<T extends AbstractUITreeNode>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        super.decodeInternal(facesContext, component);
        if (((AbstractUITreeNode)component).isDisabled()) {
            return;
        }
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        if (data instanceof AbstractUITreeListbox) {
            String marked;
            String searchString;
            String clientId = data.getClientId(facesContext);
            String nodeStateId = ((AbstractUITreeNodeBase)component).nodeStateId(facesContext);
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String nodeId = component.getClientId(facesContext);
            boolean folder = ((AbstractUITreeNodeBase)component).isFolder();
            if (folder) {
                boolean bl = Boolean.parseBoolean((String)requestParameterMap.get(nodeId + "::expanded"));
            }
            if (data.getSelectable() != Selectable.none) {
                String selected = (String)requestParameterMap.get(clientId + "::selected");
                selected = selected.replaceAll("\\[", ";");
                selected = selected.replaceAll("]", ";");
                selected = selected.replaceAll(",", ";");
                searchString = ";" + component.getClientId(facesContext) + ";";
                AbstractUITreeSelect treeSelect = ComponentUtils.findDescendant(component, AbstractUITreeSelect.class);
                if (treeSelect != null) {
                    treeSelect.setSubmittedValue(selected.contains(searchString));
                }
            }
            if ((marked = (String)requestParameterMap.get(clientId + "::marked")) != null) {
                searchString = clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + nodeStateId;
                boolean bl = marked.equals(searchString);
            } else {
                LOG.warn("This log message is help clarifying the occurrence of this else case.");
            }
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        boolean dataRendersRowContainer = data.isRendersRowContainer();
        String clientId = component.getClientId(facesContext);
        String parentId = data.getRowParentClientId();
        boolean visible = data.isRowVisible();
        boolean folder = ((AbstractUITreeNodeBase)component).isFolder();
        TreePath path = ((AbstractUITreeNodeBase)component).getPath();
        boolean expanded = folder && data.getExpandedState().isExpanded(path);
        SelectedState selectedState = data.getSelectedState();
        boolean selected = data instanceof AbstractUITree && selectedState.isSelected(path);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            writer.startElement(HtmlElements.OPTION);
            writer.writeAttribute(HtmlAttributes.VALUE, clientId, true);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SELECTED, selectedState.isAncestorOfSelected(path));
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.ROW_INDEX, data.getRowIndex());
        } else {
            writer.startElement(HtmlElements.TOBAGO_TREE_NODE);
            writer.writeIdAttribute(clientId);
            boolean hidden = !dataRendersRowContainer && !visible;
            writer.writeClassAttribute(selected ? TobagoClass.SELECTED : null, folder ? TobagoClass.FOLDER : null, expanded ? TobagoClass.EXPANDED : null, hidden ? BootstrapClass.D_NONE : null, component.getCustomClass());
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.SELECTED, selected);
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.EXPANDABLE, folder);
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.INDEX, data.getRowIndex());
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
            if (parentId != null) {
                writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
                writer.writeAttribute(CustomAttributes.PARENT, parentId, false);
            }
            writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.LEVEL, data.isShowRoot() ? ((AbstractUITreeNodeBase)component).getLevel() : ((AbstractUITreeNodeBase)component).getLevel() - 1);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        int level = ((AbstractUITreeNodeBase)component).getLevel();
        boolean folder = ((AbstractUITreeNodeBase)component).isFolder();
        boolean expanded = folder && data.getExpandedState().isExpanded(((AbstractUITreeNodeBase)component).getPath()) || level == 0;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            if (folder) {
                writer.writeText(" \u2192");
            }
            writer.endElement(HtmlElements.OPTION);
        } else {
            writer.endElement(HtmlElements.TOBAGO_TREE_NODE);
        }
    }
}

