/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.render.Renderer;
import jakarta.faces.view.Location;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class HtmlScriptRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final Logger log = Logger.getLogger(HtmlScriptRenderer.class.getName());

    @Override
    public void processEvent(ComponentSystemEvent event) {
        UIComponent uiTarget;
        FacesContext facesContext;
        UIComponent component;
        String target;
        if (event instanceof PostAddToViewEvent && (target = (String)(component = event.getComponent()).getAttributes().get("target")) != null) {
            UIComponent ccParent;
            facesContext = FacesContext.getCurrentInstance();
            Location location = (Location)component.getAttributes().get("org.apache.myfaces.compositecomponent.location");
            if (location != null && (ccParent = CompositeComponentELUtils.getCompositeComponentBasedOnLocation(facesContext, location)) != null) {
                component.getAttributes().put("oam.CC_FIND_COMPONENT_EXPRESSION", ComponentSupport.getFindComponentExpression(facesContext, ccParent));
            }
            facesContext.getViewRoot().addComponentResource(facesContext, component, target);
        }
        if (event instanceof PreRenderViewEvent && (target = (String)(component = event.getComponent()).getAttributes().get("target")) != null && (uiTarget = (facesContext = FacesContext.getCurrentInstance()).getViewRoot().getFacet(target)) == null) {
            throw new FacesException("Target for component not found");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        boolean hasChildren;
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(component, "component");
        Map<String, Object> componentAttributesMap = component.getAttributes();
        String resourceName = (String)componentAttributesMap.get("name");
        boolean bl = hasChildren = component.getChildCount() > 0;
        if (resourceName != null && !resourceName.isEmpty()) {
            if (hasChildren) {
                Level level;
                Level level2 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
                if (log.isLoggable(level)) {
                    log.log(level, "h:outputScript with resourceName " + resourceName + " and child components found. Child components will be ignored.");
                }
            }
        } else if (hasChildren) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("script", component);
            HtmlRendererUtils.renderScriptType(facesContext, writer);
            RendererUtils.renderChildren(facesContext, component);
            writer.endElement("script");
        } else {
            Level level;
            Level level3 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
            if (log.isLoggable(level)) {
                log.log(level, "h:outputScript with no name and no body content, so nothing rendered.");
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Resource resource;
        super.encodeEnd(facesContext, component);
        Map<String, Object> componentAttributesMap = component.getAttributes();
        String resourceName = (String)componentAttributesMap.get("name");
        String libraryName = (String)componentAttributesMap.get("library");
        if (resourceName == null || resourceName.isEmpty()) {
            return;
        }
        String additionalQueryParams = null;
        int index = resourceName.indexOf(63);
        if (index >= 0) {
            additionalQueryParams = resourceName.substring(index + 1);
            resourceName = resourceName.substring(0, index);
        }
        if (libraryName == null) {
            if (ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
                return;
            }
            resource = facesContext.getApplication().getResourceHandler().createResource(resourceName);
        } else {
            if (ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
                return;
            }
            resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
        }
        if (resource == null) {
            log.warning("Resource referenced by resourceName " + resourceName + (String)(libraryName == null ? "" : " and libraryName " + libraryName) + " not found in call to ResourceHandler.createResource. It will be silenty ignored.");
            return;
        }
        if (ResourceUtils.isRenderedScript(facesContext, resource.getLibraryName(), resource.getResourceName())) {
            return;
        }
        ResourceUtils.markScriptAsRendered(facesContext, libraryName, resourceName);
        ResourceUtils.markScriptAsRendered(facesContext, resource.getLibraryName(), resource.getResourceName());
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", component);
        HtmlRendererUtils.renderScriptType(facesContext, writer);
        Object path = resource.getRequestPath();
        if (additionalQueryParams != null) {
            path = (String)path + (((String)path).indexOf(63) >= 0 ? "&amp;" : "?") + additionalQueryParams;
        }
        writer.writeURIAttribute("src", facesContext.getExternalContext().encodeResourceURL((String)path), null);
        writer.endElement("script");
    }
}

