/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.StaticFieldELResolver;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.el.ELResolverBuilder;
import org.apache.myfaces.el.resolver.CompositeComponentELResolver;
import org.apache.myfaces.el.resolver.EmptyStringToNullELResolver;
import org.apache.myfaces.el.resolver.FlashELResolver;
import org.apache.myfaces.el.resolver.ImportConstantsELResolver;
import org.apache.myfaces.el.resolver.ImportHandlerResolver;
import org.apache.myfaces.el.resolver.LambdaBeanELResolver;
import org.apache.myfaces.el.resolver.ResourceBundleResolver;
import org.apache.myfaces.el.resolver.ResourceResolver;
import org.apache.myfaces.el.resolver.ScopedAttributeResolver;
import org.apache.myfaces.el.resolver.implicitobject.ImplicitObjectResolver;

public class DefaultELResolverBuilder
extends ELResolverBuilder {
    private static final Logger LOG = Logger.getLogger(DefaultELResolverBuilder.class.getName());
    public static final List<String> CDI_EL_RESOLVERS = Arrays.asList("org.apache.webbeans.el22.WebBeansELResolver", "org.apache.webbeans.el.WebBeansELResolver", "org.jboss.weld.module.web.el.WeldELResolver", "org.jboss.weld.environment.servlet.jsf.WeldApplication$LazyBeanManagerIntegrationELResolver");

    public DefaultELResolverBuilder(RuntimeConfig runtimeConfig, MyfacesConfig myfacesConfig) {
        super(runtimeConfig, myfacesConfig);
    }

    @Override
    public void build(FacesContext facesContext, CompositeELResolver compositeElResolver) {
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance());
        List<ELResolver> list = new ArrayList<ELResolver>();
        boolean replaceImplicitObjectResolverWithCDIResolver = this.isReplaceImplicitObjectResolverWithCDIResolver(facesContext);
        if (replaceImplicitObjectResolverWithCDIResolver) {
            list.add(ImplicitObjectResolver.makeResolverForCDI());
            list.add(this.getCDIELResolver());
        } else {
            list.add(ImplicitObjectResolver.makeResolver());
        }
        list.add(new CompositeComponentELResolver(config));
        if (replaceImplicitObjectResolverWithCDIResolver) {
            ArrayList<ELResolver> temp = new ArrayList<ELResolver>();
            this.addFromRuntimeConfig(temp);
            temp.removeIf(resolver -> CDI_EL_RESOLVERS.contains(resolver.getClass().getName()));
            list.addAll(temp);
        } else {
            this.addFromRuntimeConfig(list);
        }
        if ("true".equalsIgnoreCase(facesContext.getExternalContext().getInitParameter("jakarta.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL"))) {
            list.add(new EmptyStringToNullELResolver());
        }
        list.add(new FlashELResolver());
        list.add(new ResourceResolver());
        list.add((ELResolver)new ResourceBundleELResolver());
        list.add(new ResourceBundleResolver());
        list.add(new ImportConstantsELResolver());
        try {
            ELResolver streamElResolver = this.runtimeConfig.getExpressionFactory().getStreamELResolver();
            if (streamElResolver != null) {
                list.add(streamElResolver);
            }
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Could not add ExpressionFactory#getStreamELResolver!", ex);
        }
        try {
            list.add((ELResolver)new StaticFieldELResolver());
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Could not add StaticFieldELResolver!", ex);
        }
        list.add((ELResolver)new MapELResolver());
        list.add((ELResolver)new ListELResolver());
        list.add((ELResolver)new ArrayELResolver());
        if (PropertyDescriptorUtils.isUseLambdaMetafactory(facesContext.getExternalContext())) {
            list.add((ELResolver)new LambdaBeanELResolver());
        } else {
            list.add((ELResolver)new BeanELResolver());
        }
        this.sortELResolvers(list);
        list = this.wrapELResolvers(list);
        Iterable<ELResolver> filteredELResolvers = this.filterELResolvers(list);
        for (ELResolver resolver2 : filteredELResolvers) {
            compositeElResolver.add(resolver2);
        }
        if (config.isSupportEL3ImportHandler()) {
            compositeElResolver.add((ELResolver)new ImportHandlerResolver());
        }
        compositeElResolver.add((ELResolver)new ScopedAttributeResolver());
    }

    protected ELResolver getCDIELResolver() {
        BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance());
        return beanManager.getELResolver();
    }
}

