/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.scp;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.scp.common.AbstractScpTransferEventListenerAdapter;
import org.apache.sshd.scp.common.ScpTransferEventListener;

public abstract class SimpleAccessControlScpEventListener
extends AbstractScpTransferEventListenerAdapter {
    public static final SimpleAccessControlScpEventListener READ_ONLY_ACCESSOR = new SimpleAccessControlScpEventListener(){

        @Override
        protected boolean isFileUploadAllowed(Session session, Path path) throws IOException {
            return false;
        }

        @Override
        protected boolean isFileDownloadAllowed(Session session, Path path) throws IOException {
            return true;
        }
    };

    protected SimpleAccessControlScpEventListener() {
    }

    public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) throws IOException {
        super.startFileEvent(session, op, file, length, perms);
        switch (op) {
            case SEND: {
                if (this.isFileDownloadAllowed(session, file)) break;
                throw new AccessDeniedException(file.toString());
            }
            case RECEIVE: {
                if (this.isFileUploadAllowed(session, file)) break;
                throw new AccessDeniedException(file.toString());
            }
            default: {
                throw new UnsupportedOperationException("Unknown file operation: " + op);
            }
        }
    }

    public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) throws IOException {
        super.startFolderEvent(session, op, file, perms);
        switch (op) {
            case SEND: {
                if (this.isFileDownloadAllowed(session, file)) break;
                throw new AccessDeniedException(file.toString());
            }
            case RECEIVE: {
                if (this.isFileUploadAllowed(session, file)) break;
                throw new AccessDeniedException(file.toString());
            }
            default: {
                throw new UnsupportedOperationException("Unknown file operation: " + op);
            }
        }
    }

    protected abstract boolean isFileDownloadAllowed(Session var1, Path var2) throws IOException;

    protected abstract boolean isFileUploadAllowed(Session var1, Path var2) throws IOException;
}

