/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.resolution.VersionResult;

public class VersionResolutionException
extends RepositoryException {
    private final transient VersionResult result;

    public VersionResolutionException(VersionResult result) {
        super(VersionResolutionException.getMessage(result), VersionResolutionException.getFirstCause(result));
        if (result != null) {
            result.getExceptions().forEach(this::addSuppressed);
        }
        this.result = result;
    }

    private static String getMessage(VersionResult result) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("Failed to resolve version");
        if (result != null) {
            buffer.append(" for ").append(result.getRequest().getArtifact());
            if (!result.getExceptions().isEmpty()) {
                buffer.append(": ").append(result.getExceptions().iterator().next().getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getFirstCause(VersionResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }

    public VersionResolutionException(VersionResult result, String message) {
        super(message, VersionResolutionException.getFirstCause(result));
        if (result != null) {
            result.getExceptions().forEach(this::addSuppressed);
        }
        this.result = result;
    }

    public VersionResolutionException(VersionResult result, String message, Throwable cause) {
        super(message, cause);
        if (result != null) {
            result.getExceptions().forEach(this::addSuppressed);
        }
        this.result = result;
    }

    public VersionResult getResult() {
        return this.result;
    }
}

