/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.api.Language;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;

@Experimental
public interface ProjectManager
extends Service {
    @Nonnull
    public Optional<Path> getPath(@Nonnull Project var1);

    @Nonnull
    public Collection<ProducedArtifact> getAttachedArtifacts(@Nonnull Project var1);

    @Nonnull
    public Collection<ProducedArtifact> getAllArtifacts(@Nonnull Project var1);

    default public void attachArtifact(@Nonnull Session session, @Nonnull Project project, @Nonnull Path path) {
        String name = path.getFileName().toString();
        int dot = name.lastIndexOf(46);
        String ext = dot >= 1 ? name.substring(dot + 1) : "";
        ProducedArtifact artifact = session.createProducedArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), ext);
        this.attachArtifact(project, artifact, path);
    }

    default public void attachArtifact(@Nonnull Session session, @Nonnull Project project, @Nonnull String type, @Nonnull Path path) {
        ProducedArtifact artifact = session.createProducedArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, null, type);
        this.attachArtifact(project, artifact, path);
    }

    public void attachArtifact(@Nonnull Project var1, @Nonnull ProducedArtifact var2, @Nonnull Path var3);

    @Nonnull
    public Collection<SourceRoot> getSourceRoots(@Nonnull Project var1);

    @Nonnull
    public Stream<SourceRoot> getEnabledSourceRoots(@Nonnull Project var1, @Nullable ProjectScope var2, @Nullable Language var3);

    public void addSourceRoot(@Nonnull Project var1, @Nonnull SourceRoot var2);

    public void addSourceRoot(@Nonnull Project var1, @Nonnull ProjectScope var2, @Nonnull Language var3, @Nonnull Path var4);

    @Nonnull
    public List<RemoteRepository> getRemoteProjectRepositories(@Nonnull Project var1);

    @Nonnull
    public List<RemoteRepository> getRemotePluginRepositories(@Nonnull Project var1);

    @Nonnull
    public Map<String, String> getProperties(@Nonnull Project var1);

    public void setProperty(@Nonnull Project var1, @Nonnull String var2, @Nullable String var3);

    @Nonnull
    public Optional<Project> getExecutionProject(@Nonnull Project var1);
}

