/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.ui.beans;

import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.manifoldcf.core.interfaces.AuthFactory;
import org.apache.manifoldcf.core.interfaces.IAuth;
import org.apache.manifoldcf.core.interfaces.IAuthorizer;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;

public class APIProfile
implements HttpSessionBindingListener,
IAuthorizer {
    public static final String _rcsid = "@(#)$Id$";
    private long loginTime = -1L;
    private String userID = null;
    private boolean isLoggedIn = false;
    private String sessionIdentifier = null;

    public String session() {
        return this.sessionIdentifier;
    }

    public String getUserID() {
        return this.userID;
    }

    public void logout() {
        this.sessionCleanup();
    }

    public void login(IThreadContext threadContext, String userID, String userPassword) {
        this.sessionCleanup();
        try {
            IAuth auth = AuthFactory.make((IThreadContext)threadContext);
            if (auth.verifyAPILogin(userID, userPassword)) {
                this.isLoggedIn = true;
                this.loginTime = System.currentTimeMillis();
                this.userID = userID;
            }
        }
        catch (ManifoldCFException e) {
            Logging.misc.fatal((Object)("Exception logging in: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean getLoggedOn() {
        return this.isLoggedIn;
    }

    public String getLoginTime() {
        return new Date(this.loginTime).toString();
    }

    public long getLoginTimeLong() {
        return this.loginTime;
    }

    private void sessionCleanup() {
        this.isLoggedIn = false;
        this.userID = null;
        this.loginTime = -1L;
    }

    public boolean checkAllowed(IThreadContext threadContext, int capability) throws ManifoldCFException {
        if (!this.isLoggedIn) {
            return false;
        }
        IAuth auth = AuthFactory.make((IThreadContext)threadContext);
        return auth.checkCapability(this.userID, capability);
    }

    public void valueBound(HttpSessionBindingEvent e) {
        HttpSession ss = e.getSession();
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = ss.getId();
        }
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        this.sessionCleanup();
        this.sessionIdentifier = null;
    }
}

