/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.UnsupportedExtensionException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class SAMLCondition
extends SAMLObject
implements Cloneable {
    protected static Hashtable conditionTypeMap = new Hashtable();

    public static void regFactory(QName qName, String string) {
        conditionTypeMap.put(qName, string);
    }

    public static void unregFactory(QName qName) {
        conditionTypeMap.remove(qName);
    }

    public static SAMLCondition getInstance(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLCondition.getInstance() given an empty DOM");
        }
        try {
            if (XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Condition")) {
                String string = (String)conditionTypeMap.get(XML.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type"));
                if (string == null) {
                    throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLCondition.getInstance() unable to locate an implementation of specified condition type");
                }
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{Element.class};
                Object[] objectArray = new Object[]{element};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                return (SAMLCondition)constructor.newInstance(objectArray);
            }
            String string = (String)conditionTypeMap.get(new QName(element.getNamespaceURI(), element.getLocalName()));
            if (string == null) {
                throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLCondition.getInstance() unable to locate an implementation of specified condition type");
            }
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Element.class};
            Object[] objectArray = new Object[]{element};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (SAMLCondition)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to locate implementation class for condition", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to bind to constructor for condition", (Exception)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to build implementation object for condition", (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to access implementation of condition", (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAMLException) {
                throw (SAMLException)throwable;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() caught unknown exception while building condition object: " + throwable.getMessage());
        }
    }

    public static SAMLCondition getInstance(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return SAMLCondition.getInstance(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLCondition").error((Object)("caught an exception while parsing a stream:\n" + sAXException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLCondition.getInstance() caught exception while parsing a stream", (Exception)sAXException);
        }
        catch (IOException iOException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLCondition").error((Object)("caught an exception while parsing a stream:\n" + iOException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLCondition.getInstance() caught exception while parsing a stream", (Exception)iOException);
        }
    }
}

