/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine.tests;

import java.io.Reader;
import java.io.StringReader;
import org.apache.manifoldcf.scriptengine.BasicTokenStream;
import org.apache.manifoldcf.scriptengine.BreakCommand;
import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.DELETECommand;
import org.apache.manifoldcf.scriptengine.ErrorCommand;
import org.apache.manifoldcf.scriptengine.GETCommand;
import org.apache.manifoldcf.scriptengine.IfCommand;
import org.apache.manifoldcf.scriptengine.InsertCommand;
import org.apache.manifoldcf.scriptengine.NewArray;
import org.apache.manifoldcf.scriptengine.NewConfiguration;
import org.apache.manifoldcf.scriptengine.NewConfigurationNode;
import org.apache.manifoldcf.scriptengine.NewConnectionName;
import org.apache.manifoldcf.scriptengine.NewDictionary;
import org.apache.manifoldcf.scriptengine.NewOperation;
import org.apache.manifoldcf.scriptengine.NewURL;
import org.apache.manifoldcf.scriptengine.POSTCommand;
import org.apache.manifoldcf.scriptengine.PUTCommand;
import org.apache.manifoldcf.scriptengine.PrintCommand;
import org.apache.manifoldcf.scriptengine.RemoveCommand;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.SetCommand;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.WaitCommand;
import org.apache.manifoldcf.scriptengine.WhileCommand;
import org.junit.Before;

public class ScriptEngineBase {
    protected ScriptParser scriptParser = new ScriptParser();

    @Before
    public void initializeCommands() throws Exception {
        this.scriptParser.addCommand("break", (Command)new BreakCommand());
        this.scriptParser.addCommand("print", (Command)new PrintCommand());
        this.scriptParser.addCommand("if", (Command)new IfCommand());
        this.scriptParser.addCommand("while", (Command)new WhileCommand());
        this.scriptParser.addCommand("set", (Command)new SetCommand());
        this.scriptParser.addCommand("insert", (Command)new InsertCommand());
        this.scriptParser.addCommand("remove", (Command)new RemoveCommand());
        this.scriptParser.addCommand("error", (Command)new ErrorCommand());
        this.scriptParser.addCommand("wait", (Command)new WaitCommand());
        this.scriptParser.addCommand("GET", (Command)new GETCommand());
        this.scriptParser.addCommand("PUT", (Command)new PUTCommand());
        this.scriptParser.addCommand("DELETE", (Command)new DELETECommand());
        this.scriptParser.addCommand("POST", (Command)new POSTCommand());
    }

    @Before
    public void initializeNewOperations() throws Exception {
        this.scriptParser.addNewOperation("configuration", (NewOperation)new NewConfiguration());
        this.scriptParser.addNewOperation("configurationnode", (NewOperation)new NewConfigurationNode());
        this.scriptParser.addNewOperation("url", (NewOperation)new NewURL());
        this.scriptParser.addNewOperation("connectionname", (NewOperation)new NewConnectionName());
        this.scriptParser.addNewOperation("array", (NewOperation)new NewArray());
        this.scriptParser.addNewOperation("dictionary", (NewOperation)new NewDictionary());
    }

    protected VariableReference evaluateExpression(String expression) throws Exception {
        StringReader r = new StringReader(expression);
        BasicTokenStream ts = new BasicTokenStream((Reader)r);
        return this.scriptParser.evaluateExpression((TokenStream)ts);
    }

    protected boolean executeStatements(String statements) throws Exception {
        StringReader r = new StringReader(statements);
        BasicTokenStream ts = new BasicTokenStream((Reader)r);
        return this.scriptParser.parseStatements((TokenStream)ts);
    }
}

