/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.script.config.arbiter;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.script.Script;
import org.apache.logging.log4j.core.script.ScriptBindings;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.PluginNode;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.script.ScriptManagerImpl;
import org.apache.logging.log4j.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Configurable(elementType="Arbiter", deferChildren=true, printObject=true)
@Plugin
public final class ScriptArbiter
implements Arbiter {
    private final Script script;
    private final Configuration configuration;

    private ScriptArbiter(Configuration configuration, Script script) {
        this.configuration = configuration;
        this.script = script;
    }

    public boolean isCondition() {
        ScriptBindings bindings = ScriptManagerImpl.createBindings();
        bindings.putAll(this.configuration.getProperties());
        bindings.put((Object)"substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return Boolean.parseBoolean(object.toString());
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ScriptArbiter> {
        private static final Logger LOGGER = StatusLogger.getLogger();
        @PluginConfiguration
        private AbstractConfiguration configuration;
        @PluginNode
        private Node node;

        public Builder setConfiguration(AbstractConfiguration configuration) {
            this.configuration = configuration;
            return this.asBuilder();
        }

        public Builder setNode(Node node) {
            this.node = node;
            return this.asBuilder();
        }

        public Builder asBuilder() {
            return this;
        }

        public ScriptArbiter build() {
            Script script = null;
            for (Node child : this.node.getChildren()) {
                PluginType type = child.getType();
                if (type == null) {
                    LOGGER.error("Node {} is missing a Plugintype", (Object)child.getName());
                    continue;
                }
                if (!Script.class.isAssignableFrom(type.getPluginClass())) continue;
                script = (Script)this.configuration.createPluginObject(child);
                this.node.getChildren().remove(child);
                break;
            }
            if (script == null) {
                LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
                return null;
            }
            if (this.configuration.getScriptManager() == null) {
                LOGGER.error("Script support is not enabled");
                return null;
            }
            if (script instanceof ScriptRef) {
                if (this.configuration.getScriptManager().getScript(script.getName()) == null) {
                    LOGGER.error("No script with name {} has been declared.", (Object)script.getName());
                    return null;
                }
            } else if (!this.configuration.getScriptManager().addScript(script)) {
                return null;
            }
            return new ScriptArbiter((Configuration)this.configuration, script);
        }
    }
}

