/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequest;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequestImpl;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestContainer;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewerTags;
import org.apache.directory.api.ldap.model.message.Control;

public class VirtualListViewRequestFactory
extends AbstractControlFactory<VirtualListViewRequest> {
    public VirtualListViewRequestFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.9");
    }

    public VirtualListViewRequest newControl() {
        return new VirtualListViewRequestImpl();
    }

    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        VirtualListViewRequest vlvRequest = (VirtualListViewRequest)control;
        if (vlvRequest.getContextId() != null) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])vlvRequest.getContextId());
        }
        if (vlvRequest.hasOffset()) {
            int offsetStart = buffer.getPos();
            BerValue.encodeInteger((Asn1Buffer)buffer, (int)vlvRequest.getContentCount());
            BerValue.encodeInteger((Asn1Buffer)buffer, (int)vlvRequest.getOffset());
            BerValue.encodeSequence((Asn1Buffer)buffer, (byte)((byte)VirtualListViewerTags.BY_OFFSET_TAG.getValue()), (int)offsetStart);
        } else {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte)((byte)VirtualListViewerTags.ASSERTION_VALUE_TAG.getValue()), (byte[])vlvRequest.getAssertionValue());
        }
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)vlvRequest.getAfterCount());
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)vlvRequest.getBeforeCount());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }

    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new VirtualListViewRequestContainer(control), control, controlBytes);
    }
}

