/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.serializer.SerializeException;

public final class MsgPackOutputStream
extends OutputStream {
    private final OutputStream os;
    final long L2X31 = 0x80000000L;

    protected MsgPackOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) {
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
    }

    MsgPackOutputStream append(byte b) {
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    MsgPackOutputStream append(byte[] b) {
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    MsgPackOutputStream append1(int i) {
        try {
            this.os.write(i);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    MsgPackOutputStream append2(int i) {
        return this.append1(i >> 8).append1(i);
    }

    MsgPackOutputStream append4(int i) {
        return this.append1(i >> 24).append1(i >> 16).append1(i >> 8).append1(i);
    }

    MsgPackOutputStream append8(long l) {
        return this.append1((int)(l >> 56)).append1((int)(l >> 48)).append1((int)(l >> 40)).append1((int)(l >> 32)).append1((int)(l >> 24)).append1((int)(l >> 16)).append1((int)(l >> 8)).append1((int)l);
    }

    MsgPackOutputStream appendNull() {
        return this.append1(192);
    }

    MsgPackOutputStream appendBoolean(boolean b) {
        return this.append1(b ? 195 : 194);
    }

    MsgPackOutputStream appendInt(int i) {
        if (i >= 0) {
            if (i < 128) {
                return this.append1(i);
            }
            if (i < 32768) {
                return this.append1(209).append2(i);
            }
            return this.append1(210).append4(i);
        }
        if (i > -64) {
            return this.append((byte)(0xE0 | -i));
        }
        if (i > -128) {
            return this.append1(208).append1(i);
        }
        if (i > Short.MIN_VALUE) {
            return this.append1(209).append2(i);
        }
        return this.append1(210).append4(i);
    }

    MsgPackOutputStream appendLong(long l) {
        if (l < 0x80000000L && l > Integer.MIN_VALUE) {
            return this.appendInt((int)l);
        }
        return this.append1(211).append8(l);
    }

    MsgPackOutputStream appendNumber(Number n) {
        Class<?> c = n.getClass();
        if (c == Integer.class || c == Short.class || c == Byte.class || c == AtomicInteger.class) {
            return this.appendInt(n.intValue());
        }
        if (c == Long.class || c == AtomicLong.class) {
            return this.appendLong(n.longValue());
        }
        if (c == Float.class) {
            return this.appendFloat(n.floatValue());
        }
        if (c == Double.class) {
            return this.appendDouble(n.doubleValue());
        }
        if (c == BigInteger.class) {
            return this.appendLong(n.longValue());
        }
        if (c == BigDecimal.class) {
            return this.appendDouble(n.doubleValue());
        }
        return this.appendInt(0);
    }

    MsgPackOutputStream appendFloat(float f) {
        return this.append1(202).append4(Float.floatToIntBits(f));
    }

    MsgPackOutputStream appendDouble(double d) {
        return this.append1(203).append8(Double.doubleToLongBits(d));
    }

    MsgPackOutputStream appendString(CharSequence cs) {
        int length = this.getUtf8ByteLength(cs);
        if (length < 32) {
            this.append1(160 + length);
        } else if (length < 256) {
            this.append1(217).append1(length);
        } else if (length < 65536) {
            this.append1(218).append2(length);
        } else {
            this.append1(219).append4(length);
        }
        int length2 = this.writeUtf8To(cs, this.os);
        if (length != length2) {
            throw new SerializeException("Unexpected length.  Expected={0}, Actual={1}", length, length2);
        }
        return this;
    }

    MsgPackOutputStream appendBinary(byte[] b) {
        if (b.length < 256) {
            return this.append1(196).append1(b.length).append(b);
        }
        if (b.length < 65536) {
            return this.append1(197).append2(b.length).append(b);
        }
        return this.append1(198).append4(b.length).append(b);
    }

    MsgPackOutputStream appendBinary(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.pipe((InputStream)is, (OutputStream)baos, x -> {
            throw new SerializeException((Throwable)x);
        });
        byte[] b = baos.toByteArray();
        if (b.length < 256) {
            return this.append1(196).append1(b.length).append(b);
        }
        if (b.length < 65536) {
            return this.append1(197).append2(b.length).append(b);
        }
        return this.append1(198).append4(b.length).append(b);
    }

    MsgPackOutputStream startArray(int size) {
        if (size < 16) {
            return this.append1(144 + size);
        }
        if (size < 65536) {
            return this.append1(220).append2(size);
        }
        return this.append1(221).append4(size);
    }

    MsgPackOutputStream startMap(int size) {
        if (size < 16) {
            return this.append1(128 + size);
        }
        if (size < 65536) {
            return this.append1(222).append2(size);
        }
        return this.append1(223).append4(size);
    }

    private int writeUtf8To(CharSequence in, OutputStream out) {
        int count = 0;
        int len = in.length();
        for (int i = 0; i < len; ++i) {
            int c = in.charAt(i) & 0xFFFF;
            if (c <= 127) {
                this.write((byte)(c & 0xFF));
                ++count;
                continue;
            }
            if (c <= 2047) {
                this.write((byte)(192 + (c >> 6 & 0x1F)));
                this.write((byte)(128 + (c & 0x3F)));
                count += 2;
                continue;
            }
            if (c >= 55296 && c <= 57343) {
                int jchar2 = in.charAt(++i) & 0xFFFF;
                int n = (c << 10) + jchar2 + -56613888;
                this.write((byte)(240 + (n >> 18 & 7)));
                this.write((byte)(128 + (n >> 12 & 0x3F)));
                this.write((byte)(128 + (n >> 6 & 0x3F)));
                this.write((byte)(128 + (n & 0x3F)));
                count += 4;
                continue;
            }
            this.write((byte)(224 + (c >> 12 & 0xF)));
            this.write((byte)(128 + (c >> 6 & 0x3F)));
            this.write((byte)(128 + (c & 0x3F)));
            count += 3;
        }
        return count;
    }

    private int getUtf8ByteLength(CharSequence cs) {
        int count = 0;
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char ch = cs.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }
}

