/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BiMap<K, V>
implements Map<K, V> {
    private final Map<K, V> forward;
    private final Map<V, K> reverse;

    public static <K, V> Builder<K, V> create() {
        return new Builder();
    }

    public BiMap(Builder<K, V> builder) {
        Map<Object, Object> forward = builder.map.entrySet().stream().filter(x -> x.getKey() != null && x.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Object, Object> reverse = builder.map.entrySet().stream().filter(x -> x.getKey() != null && x.getValue() != null).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.forward = builder.unmodifiable ? Collections.unmodifiableMap(forward) : forward;
        this.reverse = builder.unmodifiable ? Collections.unmodifiableMap(reverse) : reverse;
    }

    public K getKey(V value) {
        return this.reverse.get(value);
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.reverse.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.forward.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.reverse.put(value, key);
        return this.forward.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V value = this.forward.remove(key);
        this.reverse.remove(value);
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.forward.putAll(m);
        m.entrySet().forEach((? super T x) -> this.reverse.put(x.getValue(), x.getKey()));
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.reverse.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.forward.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.forward.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forward.entrySet();
    }

    public static class Builder<K, V> {
        final HashMap<K, V> map = new LinkedHashMap();
        boolean unmodifiable;

        public Builder<K, V> add(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Builder<K, V> unmodifiable() {
            this.unmodifiable = true;
            return this;
        }

        public BiMap<K, V> build() {
            return new BiMap(this);
        }
    }
}

