/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.List;
import java.util.Optional;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.internal.CollectionUtils;

public class DefaultClassList {
    private final List<Class<?>> entries;

    public static DefaultClassList create() {
        return new DefaultClassList();
    }

    public static DefaultClassList of(Class<?> ... values) {
        return new DefaultClassList().add(values);
    }

    protected DefaultClassList() {
        this.entries = CollectionUtils.list(new Class[0]);
    }

    public DefaultClassList(DefaultClassList value) {
        this.entries = CollectionUtils.copyOf(value.entries);
    }

    public DefaultClassList add(Class<?> ... values) {
        CollectionUtils.prependAll(this.entries, values);
        return this;
    }

    public <T> Optional<Class<? extends T>> get(Class<T> type) {
        ArgUtils.assertArgNotNull((String)"type", type);
        for (Class<?> e : this.entries) {
            if (e == null || !type.isAssignableFrom(e)) continue;
            return CollectionUtils.optional(e);
        }
        return CollectionUtils.empty();
    }

    public DefaultClassList copy() {
        return new DefaultClassList(this);
    }
}

