/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import java.util.Optional;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.MultipartResolvingVar;
import org.apache.juneau.svl.VarResolverSession;

public class RequestSwaggerVar
extends MultipartResolvingVar {
    public static final String NAME = "RS";

    public RequestSwaggerVar() {
        super(NAME);
    }

    @Override
    protected boolean allowNested() {
        return false;
    }

    @Override
    protected boolean allowRecurse() {
        return false;
    }

    @Override
    public String resolve(VarResolverSession session, String key) throws BasicHttpException, InternalServerError {
        try {
            RestRequest req = session.getBean(RestRequest.class).orElseThrow(InternalServerError::new);
            Optional<Swagger> swagger = req.getSwagger();
            Json5Serializer s = Json5Serializer.DEFAULT;
            Optional<Operation> methodSwagger = req.getOperationSwagger();
            char c = StringUtils.charAt(key, 0);
            if (c == 'c') {
                if ("contact".equals(key)) {
                    return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getContact()).map(StringUtils::stringify).orElse(null);
                }
            } else if (c == 'd') {
                if ("description".equals(key)) {
                    return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getDescription()).orElse(null);
                }
            } else if (c == 'e') {
                if ("externalDocs".equals(key)) {
                    return swagger.map(Swagger::getExternalDocs).map(SwaggerElement::toString).orElse(null);
                }
            } else if (c == 'l') {
                if ("license".equals(key)) {
                    return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getLicense()).map(StringUtils::stringify).orElse(null);
                }
            } else if (c == 'o') {
                if ("operationDescription".equals(key)) {
                    return methodSwagger.map(Operation::getDescription).orElse(null);
                }
                if ("operationSummary".equals(key)) {
                    return methodSwagger.map(Operation::getSummary).orElse(null);
                }
            } else if (c == 'r') {
                if ("siteName".equals(key)) {
                    return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getSiteName()).orElse(null);
                }
            } else if (c == 't') {
                if ("tags".equals(key)) {
                    return swagger.map(Swagger::getTags).map(x -> s.toString(x)).orElse(null);
                }
                if ("termsOfService".equals(key)) {
                    return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getTermsOfService()).orElse(null);
                }
                if ("title".equals(key)) {
                    return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getTitle()).orElse(null);
                }
            } else if (c == 'v' && "version".equals(key)) {
                return swagger.map(Swagger::getInfo).map(x -> x == null ? null : x.getVersion()).orElse(null);
            }
            return null;
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    @Override
    public boolean canResolve(VarResolverSession session) {
        return session.getBean(RestRequest.class).isPresent();
    }
}

