/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.MediaType;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.resource.BasicResource;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.objecttools.ObjectRest;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.rest.client.ResponseHeader;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.rest.client.assertion.FluentResponseBodyAssertion;

public class ResponseContent
implements HttpEntity {
    private static final HttpEntity NULL_ENTITY = new HttpEntity(){

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public boolean isChunked() {
            return false;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Header getContentType() {
            return ResponseHeader.NULL_HEADER;
        }

        @Override
        public Header getContentEncoding() {
            return ResponseHeader.NULL_HEADER;
        }

        @Override
        public InputStream getContent() throws IOException, UnsupportedOperationException {
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public void writeTo(OutputStream outstream) throws IOException {
        }

        @Override
        public boolean isStreaming() {
            return false;
        }

        @Override
        public void consumeContent() throws IOException {
        }
    };
    private final RestClient client;
    final RestRequest request;
    final RestResponse response;
    private final HttpEntity entity;
    private HttpPartSchema schema;
    private Parser parser;
    private byte[] body;
    private boolean cached;
    boolean isConsumed;

    public ResponseContent(RestClient client, RestRequest request, RestResponse response, Parser parser) {
        this.client = client;
        this.request = request;
        this.response = response;
        this.parser = parser;
        this.entity = ObjectUtils.firstNonNull(response.asHttpResponse().getEntity(), NULL_ENTITY);
    }

    public ResponseContent parser(Parser value) {
        this.parser = value;
        return this;
    }

    public ResponseContent schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public ResponseContent cache() {
        this.cached = true;
        return this;
    }

    public InputStream asInputStream() throws IOException {
        try {
            if (this.body != null) {
                return new ByteArrayInputStream(this.body);
            }
            if (this.cached) {
                this.body = IOUtils.readBytes(this.entity.getContent());
                this.response.close();
                return new ByteArrayInputStream(this.body);
            }
            if (this.isConsumed && !this.entity.isRepeatable()) {
                throw new IllegalStateException("Method cannot be called.  Response has already been consumed.  Consider using the RestResponse.cacheBody() method.");
            }
            HttpEntity e = this.response.asHttpResponse().getEntity();
            InputStream is = e == null ? new ByteArrayInputStream(new byte[0]) : e.getContent();
            is = new EofSensorInputStream(is, new EofSensorWatcher(){

                public boolean eofDetected(InputStream wrapped) throws IOException {
                    try {
                        ResponseContent.this.response.close();
                    }
                    catch (RestCallException restCallException) {
                        // empty catch block
                    }
                    return true;
                }

                public boolean streamClosed(InputStream wrapped) throws IOException {
                    try {
                        ResponseContent.this.response.close();
                    }
                    catch (RestCallException restCallException) {
                        // empty catch block
                    }
                    return true;
                }

                public boolean streamAbort(InputStream wrapped) throws IOException {
                    try {
                        ResponseContent.this.response.close();
                    }
                    catch (RestCallException restCallException) {
                        // empty catch block
                    }
                    return true;
                }
            });
            this.isConsumed = true;
            return is;
        }
        catch (UnsupportedOperationException | RestCallException e) {
            throw new IOException(e);
        }
    }

    public Reader asReader() throws IOException {
        String cs = null;
        String ct = this.getContentType().orElse(null);
        if (ct != null && ct.contains("charset=")) {
            cs = ct.substring(ct.indexOf("charset=") + 8).trim();
        }
        return this.asReader(cs == null ? IOUtils.UTF8 : Charset.forName(cs));
    }

    public Reader asReader(Charset charset) throws IOException {
        return new InputStreamReader(this.asInputStream(), charset == null ? IOUtils.UTF8 : charset);
    }

    public byte[] asBytes() throws RestCallException {
        if (this.body == null) {
            try {
                this.body = this.entity instanceof BasicHttpEntity ? ((BasicHttpEntity)this.entity).asBytes() : IOUtils.readBytes(this.entity.getContent());
            }
            catch (IOException e) {
                throw new RestCallException(this.response, (Throwable)e, "Could not read response body.", new Object[0]);
            }
            finally {
                this.response.close();
            }
        }
        return this.body;
    }

    public RestResponse pipeTo(OutputStream os) throws IOException {
        IOUtils.pipe(this.asInputStream(), os);
        return this.response;
    }

    public RestResponse pipeTo(Writer w) throws IOException {
        return this.pipeTo(w, false);
    }

    public RestResponse pipeTo(Writer w, Charset charset) throws IOException {
        return this.pipeTo(w, charset, false);
    }

    public RestResponse pipeTo(Writer w, boolean byLines) throws IOException {
        return this.pipeTo(w, null, byLines);
    }

    public RestResponse pipeTo(Writer w, Charset charset, boolean byLines) throws IOException {
        if (byLines) {
            IOUtils.pipeLines(this.asReader(charset), w);
        } else {
            IOUtils.pipe(this.asReader(charset), w);
        }
        return this.response;
    }

    public <T> T as(Type type, Type ... args) throws RestCallException {
        return this.as(this.getClassMeta(type, args));
    }

    public <T> T as(Class<T> type) throws RestCallException {
        return this.as(this.getClassMeta(type));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T as(ClassMeta<T> type) throws RestCallException {
        try {
            ConstructorInfo ci;
            if (type.is(ResponseContent.class)) return (T)this;
            if (type.is(HttpEntity.class)) {
                return (T)this;
            }
            if (type.is(Reader.class)) {
                return (T)this.asReader();
            }
            if (type.is(InputStream.class)) {
                return (T)this.asInputStream();
            }
            if (type.is(HttpResponse.class)) {
                return (T)this.response;
            }
            if (type.is(HttpResource.class)) {
                type = this.getClassMeta(BasicResource.class);
            }
            if ((ci = type.getInfo().getPublicConstructor(x -> x.hasParamTypes(HttpResponse.class))) != null) {
                try {
                    return ci.invoke(this.response);
                }
                catch (ExecutableException e) {
                    throw ThrowableUtils.asRuntimeException(e);
                }
            }
            String ct = StringUtils.firstNonEmpty(this.response.getHeader("Content-Type").orElse("text/plain"));
            if (this.parser == null) {
                this.parser = this.client.getMatchingParser(ct);
            }
            MediaType mt = MediaType.of(ct);
            if ((this.parser == null || mt.toString().contains("text/plain") && !this.parser.canHandle(ct)) && type.hasStringMutater()) {
                return (T)type.getStringMutater().mutate(this.asString());
            }
            if (this.parser != null) {
                try (Closeable in = this.parser.isReaderParser() ? this.asReader() : this.asInputStream();){
                    ConstructorInfo c;
                    Object t = ((ParserSession.Builder)this.parser.createSession().properties((Map)JsonMap.create().inner(this.request.getSessionProperties()))).locale(this.response.getLocale()).mediaType(mt).schema(this.schema).build().parse((Object)in, type);
                    if (t == null && !type.is(String.class) && (c = type.getInfo().getPublicConstructor(ExecutableInfo::hasNoParams)) != null) {
                        try {
                            Object t2 = c.invoke(new Object[0]);
                            return t2;
                        }
                        catch (ExecutableException e) {
                            throw new ParseException(e);
                        }
                    }
                    Object object = t;
                    return (T)object;
                }
            }
            if (type.hasReaderMutater()) {
                return (T)type.getReaderMutater().mutate(this.asReader());
            }
            if (type.hasInputStreamMutater()) {
                return (T)type.getInputStreamMutater().mutate(this.asInputStream());
            }
            ct = this.response.getStringHeader("Content-Type").orElse(null);
            if (ct == null && this.client.hasParsers()) {
                throw new ParseException("Content-Type not specified in response header.  Cannot find appropriate parser.", new Object[0]);
            }
            throw new ParseException("Unsupported media-type in request header ''Content-Type'': ''{0}''", ct);
        }
        catch (IOException | ParseException e) {
            this.response.close();
            throw new RestCallException(this.response, (Throwable)e, "Could not parse response body.", new Object[0]);
        }
    }

    public <T> Future<T> asFuture(Class<T> type) throws RestCallException {
        return this.client.getExecutorService().submit(() -> this.as(type));
    }

    public <T> Future<T> asFuture(ClassMeta<T> type) throws RestCallException {
        return this.client.getExecutorService().submit(() -> this.as(type));
    }

    public <T> Future<T> asFuture(Type type, Type ... args) throws RestCallException {
        return this.client.getExecutorService().submit(() -> this.as(type, args));
    }

    public String asString() throws RestCallException {
        String string;
        block8: {
            this.cache();
            Reader r = this.asReader();
            try {
                string = IOUtils.read(r);
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.response.close();
                    throw new RestCallException(this.response, (Throwable)e, "Could not read response body.", new Object[0]);
                }
            }
            r.close();
        }
        return string;
    }

    public Future<String> asStringFuture() throws RestCallException {
        return this.client.getExecutorService().submit(this::asString);
    }

    public String asAbbreviatedString(int length) throws RestCallException {
        return StringUtils.abbreviate(this.asString(), length);
    }

    public String asHex() throws RestCallException {
        return StringUtils.toHex(this.asBytes());
    }

    public String asSpacedHex() throws RestCallException {
        return StringUtils.toSpacedHex(this.asBytes());
    }

    public ObjectRest asObjectRest(Class<?> innerType) throws RestCallException {
        return new ObjectRest(this.as(innerType));
    }

    public ObjectRest asObjectRest() throws RestCallException {
        return this.asObjectRest(JsonMap.class);
    }

    public Matcher asMatcher(Pattern pattern) throws RestCallException {
        return pattern.matcher(this.asString());
    }

    public Matcher asMatcher(String regex) throws RestCallException {
        return this.asMatcher(regex, 0);
    }

    public Matcher asMatcher(String regex, int flags) throws RestCallException {
        return this.asMatcher(Pattern.compile(regex, flags));
    }

    public FluentResponseBodyAssertion<ResponseContent> assertValue() {
        return new FluentResponseBodyAssertion<ResponseContent>(this, this);
    }

    public FluentStringAssertion<ResponseContent> assertString() {
        return new FluentResponseBodyAssertion<ResponseContent>(this, this).asString();
    }

    public FluentByteArrayAssertion<ResponseContent> assertBytes() {
        return new FluentResponseBodyAssertion<ResponseContent>(this, this).asBytes();
    }

    public <T> FluentAnyAssertion<T, ResponseContent> assertObject(Class<T> type) {
        return new FluentResponseBodyAssertion<ResponseContent>(this, this).as(type);
    }

    public <T> FluentAnyAssertion<Object, ResponseContent> assertObject(Type type, Type ... args) {
        return new FluentResponseBodyAssertion<ResponseContent>(this, this).as(type, args);
    }

    public RestResponse response() {
        return this.response;
    }

    @Override
    public boolean isRepeatable() {
        return this.cached || this.entity.isRepeatable();
    }

    @Override
    public boolean isChunked() {
        return this.entity.isChunked();
    }

    @Override
    public long getContentLength() {
        return this.body != null ? (long)this.body.length : this.entity.getContentLength();
    }

    public ResponseHeader getContentType() {
        return new ResponseHeader("Content-Type", this.request, this.response, this.entity.getContentType());
    }

    public ResponseHeader getContentEncoding() {
        return new ResponseHeader("Content-Encoding", this.request, this.response, this.entity.getContentEncoding());
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.asInputStream();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.pipeTo(outstream);
    }

    @Override
    public boolean isStreaming() {
        return this.cached ? false : this.entity.isStreaming();
    }

    @Override
    @Deprecated
    public void consumeContent() throws IOException {
        this.entity.consumeContent();
    }

    private BeanContext getBeanContext() {
        return this.parser == null ? BeanContext.DEFAULT : this.parser.getBeanContext();
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> c) {
        return this.getBeanContext().getClassMeta(c);
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.getBeanContext().getClassMeta(type, args);
    }

    public String toString() {
        try {
            return this.asString();
        }
        catch (RestCallException e) {
            return e.getLocalizedMessage();
        }
    }
}

