/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public abstract class BeanContextable
extends Context {
    final BeanContext beanContext;

    protected BeanContextable(Builder b) {
        super(b);
        this.beanContext = b.bc != null ? b.bc : b.bcBuilder.build();
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("beanContext", this.beanContext.properties());
    }

    @FluentSetters(ignore={"annotations", "debug"})
    public static abstract class Builder
    extends Context.Builder {
        BeanContext.Builder bcBuilder;
        BeanContext bc;

        protected Builder() {
            this.bcBuilder = BeanContext.create();
            this.registerBuilders(this.bcBuilder);
        }

        protected Builder(BeanContextable copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.getBeanContext().copy();
            this.registerBuilders(this.bcBuilder);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.bcBuilder.copy();
            this.bc = copyFrom.bc;
            this.registerBuilders(this.bcBuilder);
        }

        @Override
        public abstract Builder copy();

        @Override
        public HashKey hashKey() {
            return HashKey.of(super.hashKey(), this.bcBuilder.hashKey(), this.bc == null ? Integer.valueOf(0) : this.bc.hashKey);
        }

        public BeanContext.Builder beanContext() {
            return this.bcBuilder;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            operation.accept(this.beanContext());
            return this;
        }

        @FluentSetter
        public Builder beanContext(BeanContext.Builder value) {
            this.bcBuilder = value;
            return this;
        }

        @FluentSetter
        public Builder beanContext(BeanContext value) {
            this.bc = value;
            return this;
        }

        @FluentSetter
        public Builder beanClassVisibility(Visibility value) {
            this.bcBuilder.beanClassVisibility(value);
            return this;
        }

        @FluentSetter
        public Builder beanConstructorVisibility(Visibility value) {
            this.bcBuilder.beanConstructorVisibility(value);
            return this;
        }

        @FluentSetter
        public Builder beanFieldVisibility(Visibility value) {
            this.bcBuilder.beanFieldVisibility(value);
            return this;
        }

        @FluentSetter
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            this.bcBuilder.beanInterceptor(on, value);
            return this;
        }

        @FluentSetter
        public Builder beanMapPutReturnsOldValue() {
            this.bcBuilder.beanMapPutReturnsOldValue();
            return this;
        }

        @FluentSetter
        public Builder beanMethodVisibility(Visibility value) {
            this.bcBuilder.beanMethodVisibility(value);
            return this;
        }

        @FluentSetter
        public Builder beansRequireDefaultConstructor() {
            this.bcBuilder.beansRequireDefaultConstructor();
            return this;
        }

        @FluentSetter
        public Builder beansRequireSerializable() {
            this.bcBuilder.beansRequireSerializable();
            return this;
        }

        @FluentSetter
        public Builder beansRequireSettersForGetters() {
            this.bcBuilder.beansRequireSettersForGetters();
            return this;
        }

        @FluentSetter
        public Builder disableBeansRequireSomeProperties() {
            this.bcBuilder.disableBeansRequireSomeProperties();
            return this;
        }

        @FluentSetter
        public Builder beanProperties(Class<?> beanClass, String properties) {
            this.bcBuilder.beanProperties(beanClass, properties);
            return this;
        }

        @FluentSetter
        public Builder beanProperties(Map<String, Object> values) {
            this.bcBuilder.beanProperties(values);
            return this;
        }

        @FluentSetter
        public Builder beanProperties(String beanClassName, String properties) {
            this.bcBuilder.beanProperties(beanClassName, properties);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            this.bcBuilder.beanPropertiesExcludes(beanClass, properties);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            this.bcBuilder.beanPropertiesExcludes(values);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            this.bcBuilder.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            this.bcBuilder.beanPropertiesReadOnly(beanClass, properties);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            this.bcBuilder.beanPropertiesReadOnly(values);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            this.bcBuilder.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            this.bcBuilder.beanPropertiesWriteOnly(beanClass, properties);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            this.bcBuilder.beanPropertiesWriteOnly(values);
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            this.bcBuilder.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @FluentSetter
        public Builder beanDictionary(Class<?> ... values) {
            this.bcBuilder.beanDictionary(values);
            return this;
        }

        @FluentSetter
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            this.bcBuilder.dictionaryOn(on, values);
            return this;
        }

        @FluentSetter
        public <T> Builder example(Class<T> pojoClass, T o) {
            this.bcBuilder.example(pojoClass, o);
            return this;
        }

        @FluentSetter
        public <T> Builder example(Class<T> pojoClass, String json) {
            this.bcBuilder.example(pojoClass, json);
            return this;
        }

        @FluentSetter
        public Builder findFluentSetters() {
            this.bcBuilder.findFluentSetters();
            return this;
        }

        @FluentSetter
        public Builder findFluentSetters(Class<?> on) {
            this.bcBuilder.findFluentSetters(on);
            return this;
        }

        @FluentSetter
        public Builder ignoreInvocationExceptionsOnGetters() {
            this.bcBuilder.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @FluentSetter
        public Builder ignoreInvocationExceptionsOnSetters() {
            this.bcBuilder.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @FluentSetter
        public Builder disableIgnoreMissingSetters() {
            this.bcBuilder.disableIgnoreMissingSetters();
            return this;
        }

        @FluentSetter
        public Builder disableIgnoreTransientFields() {
            this.bcBuilder.disableIgnoreTransientFields();
            return this;
        }

        @FluentSetter
        public Builder ignoreUnknownBeanProperties() {
            this.bcBuilder.ignoreUnknownBeanProperties();
            return this;
        }

        @FluentSetter
        public Builder ignoreUnknownEnumValues() {
            this.bcBuilder.ignoreUnknownEnumValues();
            return this;
        }

        @FluentSetter
        public Builder disableIgnoreUnknownNullBeanProperties() {
            this.bcBuilder.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @FluentSetter
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            this.bcBuilder.implClass(interfaceClass, implClass);
            return this;
        }

        @FluentSetter
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            this.bcBuilder.implClasses(values);
            return this;
        }

        @FluentSetter
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            this.bcBuilder.interfaceClass(on, value);
            return this;
        }

        @FluentSetter
        public Builder interfaces(Class<?> ... value) {
            this.bcBuilder.interfaces(value);
            return this;
        }

        @FluentSetter
        public Builder locale(Locale value) {
            this.bcBuilder.locale(value);
            return this;
        }

        @FluentSetter
        public Builder mediaType(MediaType value) {
            this.bcBuilder.mediaType(value);
            return this;
        }

        @FluentSetter
        public Builder notBeanClasses(Class<?> ... values) {
            this.bcBuilder.notBeanClasses(values);
            return this;
        }

        @FluentSetter
        public Builder notBeanPackages(String ... values) {
            this.bcBuilder.notBeanPackages(values);
            return this;
        }

        @FluentSetter
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.bcBuilder.propertyNamer(value);
            return this;
        }

        @FluentSetter
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            this.bcBuilder.propertyNamer(on, value);
            return this;
        }

        @FluentSetter
        public Builder sortProperties() {
            this.bcBuilder.sortProperties();
            return this;
        }

        @FluentSetter
        public Builder sortProperties(Class<?> ... on) {
            this.bcBuilder.sortProperties(on);
            return this;
        }

        @FluentSetter
        public Builder stopClass(Class<?> on, Class<?> value) {
            this.bcBuilder.stopClass(on, value);
            return this;
        }

        @FluentSetter
        public Builder swaps(Class<?> ... values) {
            this.bcBuilder.swaps(values);
            return this;
        }

        @FluentSetter
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            this.bcBuilder.swap(normalClass, swappedClass, swapFunction);
            return this;
        }

        @FluentSetter
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            this.bcBuilder.swap(normalClass, swappedClass, swapFunction, unswapFunction);
            return this;
        }

        @FluentSetter
        public Builder timeZone(TimeZone value) {
            this.bcBuilder.timeZone(value);
            return this;
        }

        @FluentSetter
        public Builder typeName(Class<?> on, String value) {
            this.bcBuilder.typeName(on, value);
            return this;
        }

        @FluentSetter
        public Builder typePropertyName(String value) {
            this.bcBuilder.typePropertyName(value);
            return this;
        }

        @FluentSetter
        public Builder typePropertyName(Class<?> on, String value) {
            this.bcBuilder.typePropertyName(on, value);
            return this;
        }

        @FluentSetter
        public Builder useEnumNames() {
            this.bcBuilder.useEnumNames();
            return this;
        }

        @FluentSetter
        public Builder disableInterfaceProxies() {
            this.bcBuilder.disableInterfaceProxies();
            return this;
        }

        @FluentSetter
        public Builder useJavaBeanIntrospector() {
            this.bcBuilder.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder annotations(Annotation ... value) {
            this.bcBuilder.annotations(value);
            super.annotations(value);
            return this;
        }

        @Override
        public Builder debug() {
            this.bcBuilder.debug();
            super.debug();
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations(fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }
    }
}

