/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TimedCounterList<T>
extends AbstractList<T> {
    private final ArrayList<CounterItem<T>> m_list = new ArrayList();
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        Object t;
        this.m_lock.writeLock().lock();
        try {
            t = this.m_list.set((int)index, new CounterItem<T>(element)).m_obj;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
        return (T)t;
    }

    @Override
    public T get(int index) {
        Object t;
        this.m_lock.readLock().lock();
        try {
            t = this.m_list.get((int)index).m_obj;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return (T)t;
    }

    @Override
    public int size() {
        int size;
        this.m_lock.readLock().lock();
        try {
            size = this.m_list.size();
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return size;
    }

    @Override
    public void add(int index, T element) {
        this.m_lock.writeLock().lock();
        try {
            this.m_list.add(index, new CounterItem<T>(element));
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public T remove(int index) {
        Object t;
        this.m_lock.writeLock().lock();
        try {
            t = this.m_list.remove((int)index).m_obj;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
        return (T)t;
    }

    public int count(T obj) {
        int c;
        this.m_lock.readLock().lock();
        try {
            c = (int)this.m_list.stream().filter(i -> i.m_obj.equals(obj)).count();
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(long maxage) {
        this.m_lock.writeLock().lock();
        try {
            long now = System.currentTimeMillis();
            Iterator<CounterItem<T>> i = this.m_list.iterator();
            while (i.hasNext()) {
                CounterItem<T> ci = i.next();
                long age = now - ci.m_addTime;
                if (age <= maxage) continue;
                i.remove();
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddTime(int index) {
        long res;
        this.m_lock.readLock().lock();
        try {
            res = this.m_list.get((int)index).m_addTime;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return res;
    }

    private static class CounterItem<E> {
        private final E m_obj;
        private final long m_addTime = System.currentTimeMillis();

        public CounterItem(E o) {
            this.m_obj = o;
        }
    }
}

