/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class CookieAssertionLoginModule
extends AbstractLoginModule {
    public static final String PREFS_COOKIE_NAME = "JSPWikiAssertedName";
    private static final Logger LOG = LogManager.getLogger(CookieAssertionLoginModule.class);

    @Override
    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            String name;
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            HttpSession session = request == null ? null : request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            String string = name = request != null ? CookieAssertionLoginModule.getUserCookie(request) : null;
            if (name == null) {
                LOG.debug("No cookie {} present in session ID=:  {}", (Object)PREFS_COOKIE_NAME, (Object)sid);
                throw new FailedLoginException("The user cookie was not found.");
            }
            LOG.debug("Logged in session ID={}; asserted={}", (Object)sid, (Object)name);
            this.m_principals.add(new WikiPrincipal(name, "fullName"));
            return true;
        }
        catch (IOException e) {
            LOG.error("IOException: " + e.getMessage());
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            LOG.error("Unable to handle callback, disallowing login.", (Throwable)e);
            throw new LoginException("Unable to handle callback, disallowing login.");
        }
    }

    public static String getUserCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue((HttpServletRequest)request, (String)PREFS_COOKIE_NAME);
        String usernameCookie = TextUtil.urlDecodeUTF8((String)cookie);
        return usernameCookie != null && usernameCookie.contains("-->") ? usernameCookie.substring(0, usernameCookie.indexOf("-->")) : usernameCookie;
    }

    public static void setUserCookie(HttpServletResponse response, String name) {
        name = TextUtil.urlEncodeUTF8((String)name);
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, name);
        userId.setMaxAge(86486400);
        response.addCookie(userId);
    }

    public static void clearUserCookie(HttpServletResponse response) {
        HttpUtil.clearCookie((HttpServletResponse)response, (String)PREFS_COOKIE_NAME);
    }
}

