/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.TextUtil;

public class Installer {
    public static final String ADMIN_ID = "admin";
    public static final String ADMIN_NAME = "Administrator";
    public static final String INSTALL_INFO = "Installer.Info";
    public static final String INSTALL_ERROR = "Installer.Error";
    public static final String INSTALL_WARNING = "Installer.Warning";
    public static final String APP_NAME = "jspwiki.applicationName";
    public static final String STORAGE_DIR = "jspwiki.basicAttachmentProvider.storageDir";
    public static final String PAGE_DIR = "jspwiki.fileSystemProvider.pageDir";
    public static final String WORK_DIR = "jspwiki.workDir";
    public static final String ADMIN_GROUP = "Admin";
    public static final String PROPFILENAME = "jspwiki-custom.properties";
    public static String TMP_DIR;
    private final Session m_session;
    private final File m_propertyFile;
    private final Properties m_props;
    private final Engine m_engine;
    private final HttpServletRequest m_request;
    private boolean m_validated;

    public Installer(HttpServletRequest request, ServletConfig config) {
        this.m_engine = Wiki.engine().find(config);
        this.m_session = Wiki.session().find(this.m_engine, request);
        this.m_propertyFile = new File(TMP_DIR, PROPFILENAME);
        this.m_props = new Properties();
        this.m_request = request;
        this.m_validated = false;
        TMP_DIR = this.m_engine.getWikiProperties().getProperty(WORK_DIR);
    }

    public boolean adminExists() {
        UserManager userMgr = (UserManager)this.m_engine.getManager(UserManager.class);
        UserDatabase userDb = userMgr.getUserDatabase();
        try {
            userDb.findByLoginName(ADMIN_ID);
            return true;
        }
        catch (NoSuchPrincipalException e) {
            return false;
        }
    }

    public String createAdministrator() throws WikiSecurityException {
        Group group;
        if (!this.m_validated) {
            throw new WikiSecurityException("Cannot create administrator because one or more of the installation settings are invalid.");
        }
        if (this.adminExists()) {
            return null;
        }
        UserManager userMgr = (UserManager)this.m_engine.getManager(UserManager.class);
        UserDatabase userDb = userMgr.getUserDatabase();
        String password = null;
        try {
            userDb.findByLoginName(ADMIN_ID);
        }
        catch (NoSuchPrincipalException e) {
            password = TextUtil.generateRandomPassword();
            UserProfile profile = userDb.newProfile();
            profile.setLoginName(ADMIN_ID);
            profile.setFullname(ADMIN_NAME);
            profile.setPassword(password);
            userDb.save(profile);
        }
        GroupManager groupMgr = (GroupManager)this.m_engine.getManager(GroupManager.class);
        try {
            group = groupMgr.getGroup(ADMIN_GROUP);
            group.add(new WikiPrincipal(ADMIN_NAME));
        }
        catch (NoSuchPrincipalException e) {
            group = groupMgr.parseGroup(ADMIN_GROUP, ADMIN_NAME, true);
        }
        groupMgr.setGroup(this.m_session, group);
        return password;
    }

    public String getPropertiesList() {
        Set<String> keys = this.m_props.stringPropertyNames();
        return keys.stream().map(key -> key + " = " + this.m_props.getProperty((String)key) + "\n").collect(Collectors.joining());
    }

    public String getPropertiesPath() {
        return this.m_propertyFile.getAbsolutePath();
    }

    public String getProperty(String key) {
        return this.m_props.getProperty(key);
    }

    public void parseProperties() {
        ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
        this.m_validated = false;
        String nullValue = this.m_props.getProperty(APP_NAME, rb.getString("install.installer.default.appname"));
        this.parseProperty(APP_NAME, nullValue);
        nullValue = this.m_props.getProperty(WORK_DIR, TMP_DIR);
        this.parseProperty(WORK_DIR, nullValue);
        nullValue = this.m_props.getProperty(PAGE_DIR, this.m_props.getProperty(WORK_DIR, TMP_DIR) + File.separatorChar + "data");
        this.parseProperty(PAGE_DIR, nullValue);
        this.m_props.setProperty(STORAGE_DIR, this.m_props.getProperty(PAGE_DIR));
        this.m_props.setProperty("jspwiki.pageProvider", "VersioningFileProvider");
    }

    public void saveProperties() {
        ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
        try {
            try (OutputStream out = Files.newOutputStream(this.m_propertyFile.toPath(), new OpenOption[0]);){
                this.m_props.store(out, null);
            }
            this.m_session.addMessage(INSTALL_INFO, MessageFormat.format(rb.getString("install.installer.props.saved"), this.m_propertyFile));
        }
        catch (IOException e) {
            Object[] args = new Object[]{e.getMessage(), this.m_props.toString()};
            this.m_session.addMessage(INSTALL_ERROR, MessageFormat.format(rb.getString("install.installer.props.notsaved"), args));
        }
    }

    public boolean validateProperties() {
        ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
        this.m_session.clearMessages(INSTALL_ERROR);
        this.parseProperties();
        this.sanitizePath(PAGE_DIR);
        this.sanitizePath(STORAGE_DIR);
        this.sanitizePath(WORK_DIR);
        this.validateNotNull(PAGE_DIR, rb.getString("install.installer.validate.pagedir"));
        this.validateNotNull(APP_NAME, rb.getString("install.installer.validate.appname"));
        this.validateNotNull(WORK_DIR, rb.getString("install.installer.validate.workdir"));
        if (this.m_session.getMessages(INSTALL_ERROR).length == 0) {
            this.m_validated = true;
        }
        return this.m_validated;
    }

    private void parseProperty(String param, String defaultValue) {
        String value = this.m_request.getParameter(param);
        if (value == null) {
            value = defaultValue;
        }
        this.m_props.put(param, value);
    }

    private void sanitizePath(String key) {
        String s = this.m_props.getProperty(key);
        s = TextUtil.replaceString((String)s, (String)"\\", (String)"\\\\");
        s = s.trim();
        this.m_props.put(key, s);
    }

    public void restoreUserValues() {
        this.desanitizePath(PAGE_DIR);
        this.desanitizePath(STORAGE_DIR);
        this.desanitizePath(WORK_DIR);
    }

    private void desanitizePath(String key) {
        String s = this.m_props.getProperty(key);
        s = TextUtil.replaceString((String)s, (String)"\\\\", (String)"\\");
        s = s.trim();
        this.m_props.put(key, s);
    }

    private void validateNotNull(String key, String message) {
        String value = this.m_props.getProperty(key);
        if (value == null || value.isEmpty()) {
            this.m_session.addMessage(INSTALL_ERROR, message);
        }
    }
}

