/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SimpleMBean
implements DynamicMBean {
    private static final Logger LOG = LogManager.getLogger(SimpleMBean.class);
    protected MBeanInfo m_beanInfo;

    private static Method findGetterSetter(Class<?> clazz, String name, Class<?> parm) {
        try {
            Class[] params = new Class[]{parm};
            Class[] emptyparms = new Class[]{};
            return clazz.getDeclaredMethod(name, parm != null ? params : emptyparms);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleMBean() throws NotCompliantMBeanException {
        String[] attlist = this.getAttributeNames();
        MBeanAttributeInfo[] attributes = null;
        if (attlist != null) {
            attributes = new MBeanAttributeInfo[attlist.length];
            for (int i = 0; i < attlist.length; ++i) {
                MBeanAttributeInfo info;
                String name = attlist[i];
                name = StringUtils.capitalize((String)name);
                Method getter = SimpleMBean.findGetterSetter(this.getClass(), "get" + name, null);
                if (getter == null) {
                    getter = SimpleMBean.findGetterSetter(this.getClass(), "is" + name, null);
                }
                Method setter = null;
                if (getter != null) {
                    setter = SimpleMBean.findGetterSetter(this.getClass(), "set" + name, getter.getReturnType());
                }
                Method descriptor = SimpleMBean.findGetterSetter(this.getClass(), "get" + name + "Description", null);
                String string = "";
                if (descriptor != null) {
                    try {
                        String string2 = (String)descriptor.invoke((Object)this, (Object[])null);
                    }
                    catch (Exception e) {
                        String string3 = "Exception: " + e.getMessage();
                    }
                }
                try {
                    void var8_11;
                    info = new MBeanAttributeInfo(attlist[i], (String)var8_11, getter, setter);
                }
                catch (IntrospectionException e) {
                    throw new NotCompliantMBeanException(e.getMessage());
                }
                attributes[i] = info;
            }
        }
        String[] oplist = this.getMethodNames();
        MBeanOperationInfo[] operations = new MBeanOperationInfo[oplist.length];
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < oplist.length; ++i) {
            MBeanOperationInfo mBeanOperationInfo;
            Method method = null;
            for (Method value : methods) {
                if (!value.getName().equals(oplist[i])) continue;
                method = value;
            }
            if (method == null) {
                throw new NotCompliantMBeanException("Class declares method " + oplist[i] + ", yet does not implement it!");
            }
            operations[i] = mBeanOperationInfo = new MBeanOperationInfo(method.getName(), method);
        }
        MBeanConstructorInfo[] constructors = null;
        MBeanNotificationInfo[] notifications = null;
        this.m_beanInfo = new MBeanInfo(this.getClass().getName(), this.getDescription(), attributes, constructors, operations, notifications);
    }

    protected String getDescription() {
        return "";
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object res = null;
        try {
            String mname = "get" + StringUtils.capitalize((String)name);
            Method m = SimpleMBean.findGetterSetter(this.getClass(), mname, null);
            if (m == null) {
                throw new AttributeNotFoundException(name);
            }
            res = m.invoke((Object)this, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @Override
    public AttributeList getAttributes(String[] arg0) {
        AttributeList list = new AttributeList();
        for (String s : arg0) {
            try {
                list.add(new Attribute(s, this.getAttribute(s)));
            }
            catch (AttributeNotFoundException | MBeanException | ReflectionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.m_beanInfo;
    }

    @Override
    public Object invoke(String arg0, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(arg0)) continue;
            try {
                return method.invoke((Object)this, arg1);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e, "Wrong arguments");
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e, "No access");
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e, "Wrong target");
            }
        }
        throw new ReflectionException(null, "There is no such method " + arg0);
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String mname = "set" + StringUtils.capitalize((String)attr.getName());
        Method m = SimpleMBean.findGetterSetter(this.getClass(), mname, attr.getValue().getClass());
        if (m == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        Object[] args = new Object[]{attr.getValue()};
        try {
            m.invoke((Object)this, args);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException("Faulty argument: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Cannot access attribute " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e, "Cannot invoke attribute " + e.getMessage());
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList arg0) {
        AttributeList result = new AttributeList();
        for (Object o : arg0) {
            Attribute attr = (Attribute)o;
            try {
                this.setAttribute(attr);
                result.add(attr);
            }
            catch (AttributeNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public abstract String[] getAttributeNames();

    public abstract String[] getMethodNames();
}

