/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;
import org.apache.james.jmap.UriMatcher;
import reactor.netty.http.server.HttpServerRequest;

public class Endpoint {
    private final HttpMethod method;
    private final String path;
    private final UriMatcher uriMatcher;

    public static Endpoint ofFixedPath(HttpMethod method, String path) {
        return new Endpoint(method, path, new UriMatcher.Fixed(path));
    }

    public Endpoint(HttpMethod method, String path) {
        this.method = method;
        this.path = path;
        this.uriMatcher = UriMatcher.Impl.of(path);
    }

    private Endpoint(HttpMethod method, String path, UriMatcher uriMatcher) {
        this.method = method;
        this.path = path;
        this.uriMatcher = uriMatcher;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public boolean matches(HttpServerRequest request) {
        return this.method.equals((Object)request.method()) && this.uriMatcher.matches(request.uri());
    }

    UriMatcher getUriMatcher() {
        return this.uriMatcher;
    }

    public final boolean equals(Object o) {
        if (o instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)o;
            return Objects.equals(this.method, endpoint.method) && Objects.equals(this.path, endpoint.path);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.method, this.path);
    }
}

