/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlRequestAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.ResultSets;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CqlRequestSyncProcessor
implements RequestProcessor<Statement<?>, ResultSet> {
    private final CqlRequestAsyncProcessor asyncProcessor;

    public CqlRequestSyncProcessor(CqlRequestAsyncProcessor asyncProcessor) {
        this.asyncProcessor = asyncProcessor;
    }

    @Override
    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof Statement && resultType.equals(Statement.SYNC);
    }

    @Override
    public ResultSet process(Statement<?> request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        BlockingOperation.checkNotDriverThread();
        AsyncResultSet firstPage = CompletableFutures.getUninterruptibly(this.asyncProcessor.process(request, session, context, sessionLogPrefix));
        return ResultSets.newInstance(firstPage);
    }

    @Override
    public ResultSet newFailure(RuntimeException error) {
        throw error;
    }
}

