/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Locale;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.mailbox.model.Quota;

public class QuotaResponseEncoder
implements ImapResponseEncoder<QuotaResponse> {
    @Override
    public Class<QuotaResponse> acceptableMessages() {
        return QuotaResponse.class;
    }

    @Override
    public void encode(QuotaResponse quotaResponse, ImapResponseComposer composer) throws IOException {
        String quotaRoot = quotaResponse.getQuotaRoot();
        Quota<?, ?> quota = quotaResponse.getQuota();
        composer.untagged();
        composer.message("QUOTA");
        composer.message(quotaRoot == null ? "" : quotaRoot);
        composer.openParen();
        composer.message(quotaResponse.getResourceName());
        switch (quotaResponse.getResourceName().toUpperCase(Locale.US)) {
            case "STORAGE": {
                this.writeMessagesSize(composer, quota);
                break;
            }
            case "MESSAGE": {
                this.writeMessagesCount(composer, quota);
            }
        }
        composer.closeParen();
        composer.end();
    }

    private void writeMessagesSize(ImapResponseComposer composer, Quota<?, ?> quota) throws IOException {
        composer.message(quota.getUsed().asLong() / 1024L);
        composer.message(quota.getLimit().asLong() / 1024L);
    }

    private void writeMessagesCount(ImapResponseComposer composer, Quota<?, ?> quota) throws IOException {
        composer.message(quota.getUsed().asLong());
        composer.message(quota.getLimit().asLong());
    }
}

