/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.shared.common.error.StandardException;

class DropRoleNode
extends DDLStatementNode {
    private String roleName;

    DropRoleNode(String string, ContextManager contextManager) throws StandardException {
        super(null, contextManager);
        this.roleName = string;
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.addRequiredRolePriv(this.roleName, 20);
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String statementToString() {
        return "DROP ROLE";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropRoleConstantAction(this.roleName);
    }
}

