/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.SimpleContentHandler;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.NullOutputStream;

public class JMHLongMultipartReadBench {
    private static final byte[] CONTENT = JMHLongMultipartReadBench.loadMessage("long-multipart.msg");
    private static final byte[] CONTENT_HEADERS = JMHLongMultipartReadBench.loadMessage("long-headers.msg");
    private static final byte[] BUFFER = new byte[4096];
    private static final DefaultMessageBuilder MESSAGE_BUILDER = new DefaultMessageBuilder();

    @Test
    public void launchBenchmark() throws Exception {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".benchmark*").mode(Mode.AverageTime).addProfiler(GCProfiler.class).timeUnit(TimeUnit.MICROSECONDS).warmupTime(TimeValue.seconds((long)5L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)5L)).measurementIterations(5).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    private static byte[] loadMessage(String resourceName) {
        try {
            ClassLoader cl = JMHLongMultipartReadBench.class.getClassLoader();
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            try (InputStream instream = cl.getResourceAsStream(resourceName);){
                ContentUtil.copy((InputStream)instream, (OutputStream)outstream);
            }
            return outstream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public void benchmark1(Blackhole bh) throws Exception {
        MimeTokenStream stream = new MimeTokenStream();
        stream.parse((InputStream)new ByteArrayInputStream(CONTENT));
        EntityState state = stream.getState();
        while (state != EntityState.T_END_OF_STREAM) {
            state = stream.next();
        }
        stream.stop();
    }

    @Benchmark
    public void benchmark2(Blackhole bh) throws Exception {
        AbstractContentHandler contentHandler = new AbstractContentHandler(){};
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)contentHandler);
        parser.parse((InputStream)new ByteArrayInputStream(CONTENT));
        parser.stop();
    }

    @Benchmark
    public void benchmark3(Blackhole bh) throws Exception {
        SimpleContentHandler contentHandler = new SimpleContentHandler(){

            public void body(BodyDescriptor bd, InputStream is) throws IOException {
                while (is.read(BUFFER) != -1) {
                }
            }

            public void headers(Header header) {
            }
        };
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentDecoding(true);
        parser.setContentHandler((ContentHandler)contentHandler);
        parser.parse((InputStream)new ByteArrayInputStream(CONTENT));
        parser.stop();
    }

    @Benchmark
    public void benchmark4(Blackhole bh) throws Exception {
        Message message = MESSAGE_BUILDER.parseMessage((InputStream)new ByteArrayInputStream(CONTENT));
        bh.consume((Object)message);
        message.dispose();
    }

    @Benchmark
    public void benchmark4headers(Blackhole bh) throws Exception {
        Message message = MESSAGE_BUILDER.parseMessage((InputStream)new ByteArrayInputStream(CONTENT_HEADERS));
        bh.consume((Object)message);
        message.dispose();
    }

    @Benchmark
    public void benchmark5(Blackhole bh) throws Exception {
        Message message = MESSAGE_BUILDER.parseMessage((InputStream)new ByteArrayInputStream(CONTENT));
        new DefaultMessageWriter().writeMessage(message, (OutputStream)new NullOutputStream());
        bh.consume((Object)message);
        message.dispose();
    }

    @Benchmark
    public void benchmark7(Blackhole bh) throws Exception {
        Message message = Message.Builder.of().use((FieldParser)new LenientFieldParser()).setDate(new Date()).setSubject("Test email").setFrom("btellier@apache.org").setTo("other@apache.org").setBody("Body of the message", StandardCharsets.US_ASCII).build();
        new DefaultMessageWriter().writeMessage(message, (OutputStream)new NullOutputStream());
        bh.consume((Object)message);
        message.dispose();
    }

    @Benchmark
    public void benchmark6(Blackhole bh) throws Exception {
        Header header = MESSAGE_BUILDER.parseHeader((InputStream)new ByteArrayInputStream(CONTENT_HEADERS));
        bh.consume((Object)header);
    }
}

