/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeOutOfMemoryCriticalException;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.resource.memory.PipeTabletMemoryBlock;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletEventBatch;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeTabletBatchEvents;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventExtendableResponse;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionEventTabletResponse
extends SubscriptionEventExtendableResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionEventTabletResponse.class);
    private static final long READ_TABLET_BUFFER_SIZE = SubscriptionConfig.getInstance().getSubscriptionReadTabletBufferSize();
    private static final long PREFETCH_TABLET_BUFFER_SIZE = SubscriptionConfig.getInstance().getSubscriptionPrefetchTabletBatchMaxSizeInBytes();
    private final SubscriptionPipeTabletEventBatch batch;
    private final SubscriptionPrefetchingQueue queue;
    private final SubscriptionPipeTabletBatchEvents events;
    private final SubscriptionCommitContext commitContext;
    private final SubscriptionCommitContext rootCommitContext;
    private volatile int totalTablets;
    private final AtomicInteger nextOffset = new AtomicInteger(0);
    private volatile long totalBufferSize;
    private volatile boolean availableForNext = false;

    public SubscriptionEventTabletResponse(SubscriptionPipeTabletEventBatch batch, SubscriptionPrefetchingQueue queue, SubscriptionPipeTabletBatchEvents events, SubscriptionCommitContext commitContext, SubscriptionCommitContext rootCommitContext) {
        this.batch = batch;
        this.queue = queue;
        this.events = events;
        this.commitContext = commitContext;
        this.rootCommitContext = rootCommitContext;
        this.init();
    }

    @Override
    public void prefetchRemainingResponses() {
    }

    @Override
    public void fetchNextResponse(long offset) throws Exception {
        this.offer(this.generateNextTabletResponse());
        CachedSubscriptionPollResponse previousResponse = this.poll();
        if (Objects.isNull((Object)previousResponse)) {
            LOGGER.warn("SubscriptionEventTabletResponse {} is empty when fetching next response (broken invariant)", (Object)this);
        } else {
            previousResponse.closeMemoryBlock();
        }
    }

    @Override
    public synchronized void nack() {
        this.cleanUp();
        this.batch.resetForIteration();
        this.init();
    }

    @Override
    public synchronized void cleanUp() {
        super.cleanUp();
        this.totalTablets = 0;
        this.nextOffset.set(0);
        this.totalBufferSize = 0L;
        this.availableForNext = false;
    }

    @Override
    public boolean isCommittable() {
        return (this.availableForNext || this.hasNoMore) && this.size() == 1;
    }

    private void init() {
        if (!this.isEmpty()) {
            LOGGER.warn("SubscriptionEventTabletResponse {} is not empty when initializing (broken invariant)", (Object)this);
            return;
        }
        this.offer(this.generateEmptyTabletResponse());
    }

    private synchronized CachedSubscriptionPollResponse generateEmptyTabletResponse() {
        return new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(Collections.emptyList(), this.nextOffset.incrementAndGet()), this.commitContext);
    }

    private synchronized CachedSubscriptionPollResponse generateNextTabletResponse() throws InterruptedException, PipeRuntimeOutOfMemoryCriticalException {
        Object tablets;
        if (this.availableForNext) {
            this.queue.prefetchEvent(new SubscriptionEvent(this.batch, this.queue, this.rootCommitContext));
            this.transportIterationSnapshot();
            return new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(Collections.emptyList(), -this.totalTablets), this.commitContext);
        }
        CachedSubscriptionPollResponse response = null;
        HashMap<String, List> currentTablets = new HashMap<String, List>();
        long currentBufferSize = 0L;
        while (this.batch.hasNext()) {
            tablets = this.batch.next();
            if (Objects.isNull(tablets)) continue;
            currentTablets.computeIfAbsent((String)((Pair)tablets).left, databaseName -> new ArrayList()).addAll((Collection)((Pair)tablets).right);
            long bufferSize = ((List)((Pair)tablets).right).stream().map(PipeMemoryWeightUtil::calculateTabletSizeInBytes).reduce(Long::sum).orElse(0L);
            this.totalTablets += ((List)((Pair)tablets).right).size();
            this.totalBufferSize += bufferSize;
            currentBufferSize += bufferSize;
            if (bufferSize > READ_TABLET_BUFFER_SIZE) {
                LOGGER.warn("Detect large tablets with {} byte(s), current tablets size {} byte(s)", (Object)bufferSize, currentTablets);
                response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new HashMap(currentTablets), this.nextOffset.incrementAndGet()), this.commitContext);
                break;
            }
            if (currentBufferSize > READ_TABLET_BUFFER_SIZE) {
                response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new HashMap(currentTablets), this.nextOffset.incrementAndGet()), this.commitContext);
                break;
            }
            if (this.totalBufferSize <= PREFETCH_TABLET_BUFFER_SIZE || !this.batch.hasNext()) continue;
            this.availableForNext = true;
            break;
        }
        if (Objects.isNull(response)) {
            if (currentTablets.isEmpty()) {
                this.transportIterationSnapshot();
                response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(Collections.emptyList(), -this.totalTablets), this.commitContext);
                this.hasNoMore = true;
            } else {
                response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new HashMap(currentTablets), this.nextOffset.incrementAndGet()), this.commitContext);
            }
        }
        if (Objects.nonNull(tablets = ((TabletsPayload)response.getPayload()).getTablets()) && !tablets.isEmpty()) {
            PipeTabletMemoryBlock memoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(currentBufferSize);
            response.setMemoryBlock(memoryBlock);
        }
        return response;
    }

    private void waitForResourceEnough4Parsing(long timeoutMs) throws InterruptedException {
        long currentTime;
        long startTime;
        PipeMemoryManager memoryManager = PipeDataNodeResourceManager.memory();
        if (memoryManager.isEnough4TabletParsing()) {
            return;
        }
        long lastRecordTime = startTime = System.currentTimeMillis();
        long memoryCheckIntervalMs = SubscriptionConfig.getInstance().getSubscriptionCheckMemoryEnoughIntervalMs();
        while (!memoryManager.isEnough4TabletParsing()) {
            Thread.sleep(memoryCheckIntervalMs);
            currentTime = System.currentTimeMillis();
            double elapsedRecordTimeSeconds = (double)(currentTime - lastRecordTime) / 1000.0;
            double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
            if (elapsedRecordTimeSeconds > 10.0) {
                LOGGER.info("SubscriptionEventTabletResponse {} wait for resource enough for parsing tablets {} seconds.", (Object)this.commitContext, (Object)waitTimeSeconds);
                lastRecordTime = currentTime;
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SubscriptionEventTabletResponse {} wait for resource enough for parsing tablets {} seconds.", (Object)this.commitContext, (Object)waitTimeSeconds);
            }
            if (!(waitTimeSeconds * 1000.0 > (double)timeoutMs)) continue;
            throw new PipeException(String.format("TimeoutException: Waited %s seconds", waitTimeSeconds));
        }
        currentTime = System.currentTimeMillis();
        double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
        LOGGER.info("SubscriptionEventTabletResponse {} wait for resource enough for parsing tablets {} seconds.", (Object)this.commitContext, (Object)waitTimeSeconds);
    }

    private void transportIterationSnapshot() {
        this.events.receiveIterationSnapshot(this.batch.sendIterationSnapshot());
    }

    @Override
    public String toString() {
        return "SubscriptionEventTabletResponse" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> result = super.coreReportMessage();
        result.put("totalTablets", String.valueOf(this.totalTablets));
        result.put("nextOffset", String.valueOf(this.nextOffset));
        result.put("totalBufferSize", String.valueOf(this.totalBufferSize));
        result.put("availableForNext", String.valueOf(this.availableForNext));
        return result;
    }
}

