/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DataOrganizationSpecification {
    private final List<Symbol> partitionBy;
    private final Optional<OrderingScheme> orderingScheme;

    public DataOrganizationSpecification(List<Symbol> partitionBy, Optional<OrderingScheme> orderingScheme) {
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
    }

    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.partitionBy.size(), (OutputStream)dataOutputStream);
        for (Symbol symbol : this.partitionBy) {
            Symbol.serialize(symbol, dataOutputStream);
        }
        if (this.orderingScheme.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)dataOutputStream);
            this.orderingScheme.get().serialize(dataOutputStream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)dataOutputStream);
        }
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.partitionBy.size(), (ByteBuffer)buffer);
        for (Symbol symbol : this.partitionBy) {
            Symbol.serialize(symbol, buffer);
        }
        if (this.orderingScheme.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)buffer);
            this.orderingScheme.get().serialize(buffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)buffer);
        }
    }

    public static DataOrganizationSpecification deserialize(ByteBuffer buffer) {
        int partitionBySize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ImmutableList.Builder partitionBy = ImmutableList.builder();
        for (int i = 0; i < partitionBySize; ++i) {
            partitionBy.add((Object)Symbol.deserialize(buffer));
        }
        Optional<OrderingScheme> orderingScheme = ReadWriteIOUtils.readBoolean((ByteBuffer)buffer) ? Optional.of(OrderingScheme.deserialize(buffer)) : Optional.empty();
        return new DataOrganizationSpecification((List<Symbol>)partitionBy.build(), orderingScheme);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataOrganizationSpecification that = (DataOrganizationSpecification)o;
        return Objects.equals(this.partitionBy, that.partitionBy) && Objects.equals(this.orderingScheme, that.orderingScheme);
    }

    public int hashCode() {
        return Objects.hash(this.partitionBy, this.orderingScheme);
    }
}

