/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskId;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class AssignUniqueIdOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AssignUniqueIdOperator.class);
    private static final long ROW_IDS_PER_REQUEST = 0x100000L;
    private static final long MAX_ROW_ID = 0x10000000000L;
    private final OperatorContext operatorContext;
    private final Operator child;
    private final AtomicLong rowIdPool = new AtomicLong();
    private final long uniqueValueMask;
    private long rowIdCounter;
    private long maxRowIdCounterValue;

    public AssignUniqueIdOperator(OperatorContext operatorContext, Operator child) {
        this.operatorContext = operatorContext;
        this.child = child;
        DriverTaskId id = operatorContext.getDriverContext().getDriverTaskID();
        this.uniqueValueMask = (long)id.getFragmentId().getId() << 54 | (long)id.getPipelineId() << 40;
        this.requestValues();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock tsBlock = this.child.nextWithTimer();
        if (tsBlock == null || tsBlock.isEmpty()) {
            return null;
        }
        return tsBlock.appendValueColumns(new Column[]{this.generateIdColumn(tsBlock.getPositionCount())});
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        if (this.child != null) {
            this.child.close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize() + 64L * (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    private Column generateIdColumn(int positionCount) {
        LongColumnBuilder columnBuilder = new LongColumnBuilder(null, positionCount);
        for (int currentPosition = 0; currentPosition < positionCount; ++currentPosition) {
            long rowId;
            if (this.rowIdCounter >= this.maxRowIdCounterValue) {
                this.requestValues();
            }
            ++this.rowIdCounter;
            Verify.verify(((rowId & this.uniqueValueMask) == 0L ? 1 : 0) != 0, (String)"RowId and uniqueValue mask overlaps", (Object[])new Object[0]);
            columnBuilder.writeLong(this.uniqueValueMask | rowId);
        }
        return columnBuilder.build();
    }

    private void requestValues() {
        this.rowIdCounter = this.rowIdPool.getAndAdd(0x100000L);
        this.maxRowIdCounterValue = Math.min(this.rowIdCounter + 0x100000L, 0x10000000000L);
        Preconditions.checkState((this.rowIdCounter < 0x10000000000L ? 1 : 0) != 0, (String)"Unique row id exceeds a limit: %s", (long)0x10000000000L);
    }
}

