/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.tsfile.file.metadata.IDeviceID;

public abstract class SeriesPartitionExecutor {
    protected static SeriesPartitionExecutor EXECUTOR;
    protected final int seriesPartitionSlotNum;
    protected final int NULL_SEGMENT_HASH_NUM = 65536;

    public SeriesPartitionExecutor(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    @TestOnly
    public abstract TSeriesPartitionSlot getSeriesPartitionSlot(String var1);

    public abstract TSeriesPartitionSlot getSeriesPartitionSlot(IDeviceID var1);

    public static SeriesPartitionExecutor getSeriesPartitionExecutor(String executorName, int seriesPartitionSlotNum) {
        if (EXECUTOR == null) {
            SeriesPartitionExecutor.initStaticSeriesPartitionExecutor(executorName, seriesPartitionSlotNum);
        }
        return EXECUTOR;
    }

    private static synchronized void initStaticSeriesPartitionExecutor(String executorName, int seriesPartitionSlotNum) {
        if (EXECUTOR == null) {
            try {
                Class<?> executor = Class.forName(executorName);
                Constructor<?> executorConstructor = executor.getConstructor(Integer.TYPE);
                EXECUTOR = (SeriesPartitionExecutor)executorConstructor.newInstance(seriesPartitionSlotNum);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Couldn't Constructor SeriesPartitionExecutor class: %s", executorName));
            }
        }
    }
}

